/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger counter = new AtomicInteger();

    public DaemonThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t2 = Executors.defaultThreadFactory().newThread(runnable);
        try {
            t2.setDaemon(true);
            t2.setName(this.namePrefix + "-" + this.counter.incrementAndGet());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return t2;
    }
}

