/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.internal;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.Clock;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TestClock
implements Clock {
    private long currentEpochNanos;

    private TestClock(long epochNanos) {
        this.currentEpochNanos = epochNanos;
    }

    public static TestClock create() {
        return TestClock.create(TimeUnit.MILLISECONDS.toNanos(1557212400000L));
    }

    public static TestClock create(long epochNanos) {
        return new TestClock(epochNanos);
    }

    public synchronized void setTime(long epochNanos) {
        this.currentEpochNanos = epochNanos;
    }

    public synchronized void advanceMillis(long millis) {
        long nanos = TimeUnit.MILLISECONDS.toNanos(millis);
        this.currentEpochNanos += nanos;
    }

    public synchronized void advanceNanos(long nanos) {
        this.currentEpochNanos += nanos;
    }

    @Override
    public synchronized long now() {
        return this.currentEpochNanos;
    }

    @Override
    public synchronized long nanoTime() {
        return this.currentEpochNanos;
    }
}

