/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.LongSumData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class CountAggregator
extends AbstractAggregator<Long> {
    private final AggregationTemporality temporality;

    CountAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, AggregationTemporality temporality) {
        super(resource, instrumentationLibraryInfo, descriptor, temporality == AggregationTemporality.CUMULATIVE);
        this.temporality = temporality;
    }

    @Override
    public AggregatorHandle<Long> createHandle() {
        return new Handle();
    }

    @Override
    public Long accumulateDouble(double value) {
        return 1L;
    }

    @Override
    public Long accumulateLong(long value) {
        return 1L;
    }

    @Override
    public Long merge(Long a1, Long a2) {
        return a1 + a2;
    }

    @Override
    public MetricData toMetricData(Map<Labels, Long> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createLongSum(this.getResource(), this.getInstrumentationLibraryInfo(), this.getInstrumentDescriptor().getName(), this.getInstrumentDescriptor().getDescription(), "1", LongSumData.create(true, this.temporality, MetricDataUtils.toLongPointList(accumulationByLabels, this.temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Long> {
        private static final long DEFAULT_VALUE = 0L;
        private final AtomicLong current = new AtomicLong(0L);

        private Handle() {
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.getAndAdd(1L);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.getAndAdd(1L);
        }

        @Override
        protected Long doAccumulateThenReset() {
            return this.current.getAndSet(0L);
        }
    }
}

