/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.export;

import com.aliyun.openservices.ons.shaded.com.google.auto.value.AutoValue;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.internal.DaemonThreadFactory;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.export.AutoValue_IntervalMetricReader_InternalState;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.export.IntervalMetricReaderBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.export.MetricExporter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.export.MetricProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

public final class IntervalMetricReader {
    private static final Logger logger = Logger.getLogger(IntervalMetricReader.class.getName());
    private final Exporter exporter;
    private final ScheduledExecutorService scheduler;
    private volatile ScheduledFuture<?> scheduledFuture;
    private final Object lock = new Object();

    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            CompletableResultCode flushResult = this.exporter.doRun();
            flushResult.join(5L, TimeUnit.SECONDS);
            CompletableResultCode shutdownResult = this.exporter.shutdown();
            shutdownResult.whenComplete(new Runnable(shutdownResult, result){
                final /* synthetic */ CompletableResultCode val$shutdownResult;
                final /* synthetic */ CompletableResultCode val$result;
                {
                    this.val$shutdownResult = completableResultCode;
                    this.val$result = completableResultCode2;
                }

                @Override
                public void run() {
                    if (!this.val$shutdownResult.isSuccess()) {
                        this.val$result.fail();
                    } else {
                        this.val$result.succeed();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            try {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
                CompletableResultCode shutdownResult = this.exporter.shutdown();
                shutdownResult.whenComplete(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                CompletableResultCode shutdownResult = this.exporter.shutdown();
                shutdownResult.whenComplete(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        return result;
    }

    public static IntervalMetricReaderBuilder builder() {
        return new IntervalMetricReaderBuilder(InternalState.builder());
    }

    IntervalMetricReader(InternalState internalState) {
        this(internalState, Executors.newScheduledThreadPool(1, new DaemonThreadFactory("IntervalMetricReader")));
    }

    IntervalMetricReader(InternalState internalState, ScheduledExecutorService intervalMetricReader) {
        this.exporter = new Exporter(internalState);
        this.scheduler = intervalMetricReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntervalMetricReader start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.scheduledFuture != null) {
                return this;
            }
            this.scheduledFuture = this.scheduler.scheduleAtFixedRate(this.exporter, this.exporter.internalState.getExportIntervalMillis(), this.exporter.internalState.getExportIntervalMillis(), TimeUnit.MILLISECONDS);
            return this;
        }
    }

    @AutoValue
    @Immutable
    static abstract class InternalState {
        static final long DEFAULT_INTERVAL_MILLIS = 60000L;

        InternalState() {
        }

        abstract MetricExporter getMetricExporter();

        abstract long getExportIntervalMillis();

        abstract Collection<MetricProducer> getMetricProducers();

        static Builder builder() {
            return new AutoValue_IntervalMetricReader_InternalState.Builder().setExportIntervalMillis(60000L);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setExportIntervalMillis(long var1);

            abstract Builder setMetricExporter(MetricExporter var1);

            abstract Builder setMetricProducers(Collection<MetricProducer> var1);

            abstract InternalState build();
        }
    }

    private static final class Exporter
    implements Runnable {
        private final InternalState internalState;
        private final AtomicBoolean exportAvailable = new AtomicBoolean(true);

        private Exporter(InternalState internalState) {
            this.internalState = internalState;
        }

        @Override
        public void run() {
            this.doRun();
        }

        CompletableResultCode doRun() {
            final CompletableResultCode flushResult = new CompletableResultCode();
            if (this.exportAvailable.compareAndSet(true, false)) {
                try {
                    ArrayList<MetricData> metricsList = new ArrayList<MetricData>();
                    for (MetricProducer metricProducer : this.internalState.getMetricProducers()) {
                        metricsList.addAll(metricProducer.collectAllMetrics());
                    }
                    final CompletableResultCode result = this.internalState.getMetricExporter().export(Collections.unmodifiableList(metricsList));
                    result.whenComplete(new Runnable(){

                        @Override
                        public void run() {
                            if (!result.isSuccess()) {
                                logger.log(Level.FINE, "Exporter failed");
                            }
                            flushResult.succeed();
                            Exporter.this.exportAvailable.set(true);
                        }
                    });
                }
                catch (Throwable t2) {
                    this.exportAvailable.set(true);
                    logger.log(Level.WARNING, "Exporter threw an Exception", t2);
                    flushResult.fail();
                }
            } else {
                logger.log(Level.FINE, "Exporter busy. Dropping metrics.");
                flushResult.fail();
            }
            return flushResult;
        }

        CompletableResultCode shutdown() {
            return this.internalState.getMetricExporter().shutdown();
        }
    }
}

