/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.AsynchronousInstrument;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BoundLongCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.GlobalMeterProvider;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.Meter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Consumer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Context;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.internal.DaemonThreadFactory;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.ReadWriteSpan;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.ReadableSpan;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SpanProcessor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.data.SpanData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export.SpanExporter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.internal.JcTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BatchSpanProcessor
extends SpanProcessor {
    private static final String WORKER_THREAD_NAME = BatchSpanProcessor.class.getSimpleName() + "_WorkerThread";
    private static final String SPAN_PROCESSOR_TYPE_LABEL = "spanProcessorType";
    private static final String SPAN_PROCESSOR_TYPE_VALUE = BatchSpanProcessor.class.getSimpleName();
    private final Worker worker;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static BatchSpanProcessorBuilder builder(SpanExporter spanExporter) {
        return new BatchSpanProcessorBuilder(spanExporter);
    }

    BatchSpanProcessor(SpanExporter spanExporter, long scheduleDelayNanos, int maxQueueSize, int maxExportBatchSize, long exporterTimeoutNanos) {
        this.worker = new Worker(spanExporter, scheduleDelayNanos, maxExportBatchSize, exporterTimeoutNanos, JcTools.newMpscArrayQueue(maxQueueSize, new ArrayBlockingQueue(8)));
        Thread workerThread = new DaemonThreadFactory(WORKER_THREAD_NAME).newThread(this.worker);
        workerThread.start();
    }

    @Override
    public void onStart(Context parentContext, ReadWriteSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (!span.getSpanContext().isSampled()) {
            return;
        }
        this.worker.addSpan(span);
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        return this.worker.shutdown();
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.worker.forceFlush();
    }

    ArrayList<SpanData> getBatch() {
        return this.worker.batch;
    }

    private static final class Worker
    implements Runnable {
        private final BoundLongCounter droppedSpans;
        private final BoundLongCounter exportedSpans;
        private static final Logger logger = Logger.getLogger(Worker.class.getName());
        private final SpanExporter spanExporter;
        private final long scheduleDelayNanos;
        private final int maxExportBatchSize;
        private final long exporterTimeoutNanos;
        private long nextExportTime;
        private final Queue<ReadableSpan> queue;
        private final AtomicInteger spansNeeded = new AtomicInteger(Integer.MAX_VALUE);
        private final BlockingQueue<Boolean> signal;
        private final AtomicReference<CompletableResultCode> flushRequested = new AtomicReference();
        private volatile boolean continueWork = true;
        private final ArrayList<SpanData> batch;

        private Worker(SpanExporter spanExporter, long scheduleDelayNanos, int maxExportBatchSize, long exporterTimeoutNanos, final Queue<ReadableSpan> queue) {
            this.spanExporter = spanExporter;
            this.scheduleDelayNanos = scheduleDelayNanos;
            this.maxExportBatchSize = maxExportBatchSize;
            this.exporterTimeoutNanos = exporterTimeoutNanos;
            this.queue = queue;
            this.signal = new ArrayBlockingQueue<Boolean>(1);
            Meter meter = GlobalMeterProvider.getMeter("com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace");
            meter.longValueObserverBuilder("queueSize").setDescription("The number of spans queued").setUnit("1").setUpdater(new Consumer<AsynchronousInstrument.LongResult>(){

                @Override
                public void accept(AsynchronousInstrument.LongResult result) {
                    result.observe(queue.size(), Labels.of(BatchSpanProcessor.SPAN_PROCESSOR_TYPE_LABEL, SPAN_PROCESSOR_TYPE_VALUE));
                }
            }).build();
            LongCounter processedSpansCounter = meter.longCounterBuilder("processedSpans").setUnit("1").setDescription("The number of spans processed by the BatchSpanProcessor. [dropped=true if they were dropped due to high throughput]").build();
            this.droppedSpans = processedSpansCounter.bind(Labels.of(BatchSpanProcessor.SPAN_PROCESSOR_TYPE_LABEL, SPAN_PROCESSOR_TYPE_VALUE, "dropped", "true"));
            this.exportedSpans = processedSpansCounter.bind(Labels.of(BatchSpanProcessor.SPAN_PROCESSOR_TYPE_LABEL, SPAN_PROCESSOR_TYPE_VALUE, "dropped", "false"));
            this.batch = new ArrayList(this.maxExportBatchSize);
        }

        private void addSpan(ReadableSpan span) {
            if (!this.queue.offer(span)) {
                this.droppedSpans.add(1L);
            } else if (this.queue.size() >= this.spansNeeded.get()) {
                this.signal.offer(true);
            }
        }

        @Override
        public void run() {
            this.updateNextExportTime();
            while (this.continueWork) {
                if (this.flushRequested.get() != null) {
                    this.flush();
                }
                while (!this.queue.isEmpty() && this.batch.size() < this.maxExportBatchSize) {
                    this.batch.add(this.queue.poll().toSpanData());
                }
                if (this.batch.size() >= this.maxExportBatchSize || System.nanoTime() >= this.nextExportTime) {
                    this.exportCurrentBatch();
                    this.updateNextExportTime();
                }
                if (!this.queue.isEmpty()) continue;
                try {
                    long pollWaitTime = this.nextExportTime - System.nanoTime();
                    if (pollWaitTime <= 0L) continue;
                    this.spansNeeded.set(this.maxExportBatchSize - this.batch.size());
                    this.signal.poll(pollWaitTime, TimeUnit.NANOSECONDS);
                    this.spansNeeded.set(Integer.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        private void flush() {
            for (int spansToFlush = this.queue.size(); spansToFlush > 0; --spansToFlush) {
                ReadableSpan span = this.queue.poll();
                assert (span != null);
                this.batch.add(span.toSpanData());
                if (this.batch.size() < this.maxExportBatchSize) continue;
                this.exportCurrentBatch();
            }
            this.exportCurrentBatch();
            this.flushRequested.get().succeed();
            this.flushRequested.set(null);
        }

        private void updateNextExportTime() {
            this.nextExportTime = System.nanoTime() + this.scheduleDelayNanos;
        }

        private CompletableResultCode shutdown() {
            final CompletableResultCode result = new CompletableResultCode();
            final CompletableResultCode flushResult = this.forceFlush();
            flushResult.whenComplete(new Runnable(){

                @Override
                public void run() {
                    Worker.this.continueWork = false;
                    final CompletableResultCode shutdownResult = Worker.this.spanExporter.shutdown();
                    shutdownResult.whenComplete(new Runnable(){

                        @Override
                        public void run() {
                            if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                                result.fail();
                            } else {
                                result.succeed();
                            }
                        }
                    });
                }
            });
            return result;
        }

        private CompletableResultCode forceFlush() {
            CompletableResultCode possibleResult;
            CompletableResultCode flushResult = new CompletableResultCode();
            if (this.flushRequested.compareAndSet(null, flushResult)) {
                this.signal.offer(true);
            }
            return (possibleResult = this.flushRequested.get()) == null ? CompletableResultCode.ofSuccess() : possibleResult;
        }

        private void exportCurrentBatch() {
            if (this.batch.isEmpty()) {
                return;
            }
            try {
                CompletableResultCode result = this.spanExporter.export(Collections.unmodifiableList(this.batch));
                result.join(this.exporterTimeoutNanos, TimeUnit.NANOSECONDS);
                if (result.isSuccess()) {
                    this.exportedSpans.add(this.batch.size());
                } else {
                    logger.log(Level.FINE, "Exporter failed");
                }
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exporter threw an Exception", e);
            }
            finally {
                this.batch.clear();
            }
        }
    }
}

