/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.common.Attributes;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceState;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers.ImmutableSamplingResult;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class SamplingResult {
    public static SamplingResult create(SamplingDecision decision) {
        switch (decision) {
            case RECORD_AND_SAMPLE: {
                return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
            }
            case RECORD_ONLY: {
                return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
            }
            case DROP: {
                return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
            }
        }
        throw new AssertionError((Object)"unrecognised samplingResult");
    }

    public static SamplingResult create(SamplingDecision decision, Attributes attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        return attributes.isEmpty() ? SamplingResult.create(decision) : ImmutableSamplingResult.createSamplingResult(decision, attributes);
    }

    public abstract SamplingDecision getDecision();

    public abstract Attributes getAttributes();

    public TraceState getUpdatedTraceState(TraceState parentTraceState) {
        return parentTraceState;
    }
}

