/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer;

import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.FutureCallback;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.Futures;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.SettableFuture;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.ConsumeStatus;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.listener.MessageListener;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer.ConsumeTask;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageExt;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageInterceptor;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageQueue;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.misc.Dispatcher;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class ConsumeService
extends Dispatcher {
    private static final Logger log = LoggerFactory.getLogger(ConsumeService.class);
    private static final long SIGNAL_PERIOD_MILLIS = 10L;
    protected final ConcurrentMap<MessageQueue, ProcessQueue> processQueueTable;
    private final MessageListener messageListener;
    private final MessageInterceptor interceptor;
    private final ThreadPoolExecutor consumptionExecutor;
    private final ScheduledExecutorService scheduler;

    public ConsumeService(MessageListener messageListener, MessageInterceptor interceptor, ThreadPoolExecutor consumptionExecutor, ScheduledExecutorService scheduler, ConcurrentMap<MessageQueue, ProcessQueue> processQueueTable) {
        super(10L, scheduler);
        this.messageListener = messageListener;
        this.interceptor = interceptor;
        this.consumptionExecutor = consumptionExecutor;
        this.scheduler = scheduler;
        this.processQueueTable = processQueueTable;
    }

    @Override
    protected void startUp() {
        log.info("Begin to start the consume service.");
        super.startUp();
        log.info("The consume service starts successfully.");
    }

    @Override
    protected void shutDown() throws InterruptedException {
        log.info("Begin to shutdown the consume service.");
        super.shutDown();
        log.info("Shutdown the consume service successfully.");
    }

    public abstract boolean dispatch0();

    @Override
    public void dispatch() {
        boolean dispatched;
        while (dispatched = this.dispatch0()) {
        }
    }

    public ListenableFuture<ConsumeStatus> consume(MessageExt messageExt) {
        ArrayList<MessageExt> messageExtList = new ArrayList<MessageExt>();
        messageExtList.add(messageExt);
        return this.consume(messageExtList);
    }

    public ListenableFuture<ConsumeStatus> consume(MessageExt messageExt, long delay, TimeUnit timeUnit) {
        ArrayList<MessageExt> messageExtList = new ArrayList<MessageExt>();
        messageExtList.add(messageExt);
        return this.consume(messageExtList, delay, timeUnit);
    }

    public ListenableFuture<ConsumeStatus> consume(List<MessageExt> messageExtList) {
        return this.consume(messageExtList, 0L, TimeUnit.MILLISECONDS);
    }

    public ListenableFuture<ConsumeStatus> consume(List<MessageExt> messageExtList, long delay, TimeUnit timeUnit) {
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator(this.consumptionExecutor);
        ConsumeTask task = new ConsumeTask(this.interceptor, this.messageListener, messageExtList);
        if (delay <= 0L) {
            return executorService.submit((Callable)task);
        }
        final SettableFuture<ConsumeStatus> future0 = SettableFuture.create();
        this.scheduler.schedule(() -> {
            Future future = executorService.submit((Callable)task);
            Futures.addCallback(future, new FutureCallback<ConsumeStatus>(){

                @Override
                public void onSuccess(ConsumeStatus consumeStatus) {
                    future0.set(consumeStatus);
                }

                @Override
                public void onFailure(Throwable t2) {
                    log.error("[Bug] Exception raised while submitting scheduled consumption task", t2);
                }
            }, MoreExecutors.directExecutor());
        }, delay, timeUnit);
        return future0;
    }
}

