/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message;

import com.aliyun.openservices.ons.shaded.com.google.common.base.Preconditions;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageHookPointStatus;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageInterceptor;
import java.util.concurrent.TimeUnit;

public class MessageInterceptorContext {
    private final Builder builder;
    private final MessageHookPointStatus status;
    private final String topic;
    private final int batchSize;
    private final int attempt;
    private final long duration;
    private final TimeUnit timeUnit;
    private final Throwable throwable;

    MessageInterceptorContext(Builder builder, MessageHookPointStatus status, String topic, int batchSize, int attempt, long duration, TimeUnit timeUnit, Throwable throwable) {
        this.builder = builder;
        this.status = status;
        this.topic = topic;
        this.batchSize = batchSize;
        this.attempt = attempt;
        this.duration = duration;
        this.timeUnit = timeUnit;
        this.throwable = throwable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return this.builder;
    }

    public MessageHookPointStatus getStatus() {
        return this.status;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public static class Builder {
        private MessageHookPointStatus status = MessageHookPointStatus.UNSET;
        private String topic;
        private int batchSize = 1;
        private int attempt = 1;
        private long duration = 0L;
        private TimeUnit timeUnit = MessageInterceptor.DEFAULT_TIME_UNIT;
        private Throwable throwable = null;

        Builder() {
        }

        public Builder setStatus(MessageHookPointStatus status) {
            this.status = Preconditions.checkNotNull(status, "status");
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder setAttempt(int attempt) {
            this.attempt = attempt;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = Preconditions.checkNotNull(timeUnit, "timeUnit");
            return this;
        }

        public Builder setThrowable(Throwable throwable) {
            this.throwable = Preconditions.checkNotNull(throwable, "throwable");
            return this;
        }

        public MessageInterceptorContext build() {
            return new MessageInterceptorContext(this, this.status, this.topic, this.batchSize, this.attempt, this.duration, this.timeUnit, this.throwable);
        }
    }
}

