/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.misc;

import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.AbstractIdleService;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.ExecutorServices;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.ThreadFactoryImpl;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Dispatcher
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(Dispatcher.class);
    private final AtomicBoolean dispatchTaskInQueue = new AtomicBoolean(false);
    private final long signalPeriodMillis;
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor dispatcherExecutor;
    private volatile ScheduledFuture<?> dispatchFuture;

    public Dispatcher(long signalPeriodMillis, ScheduledExecutorService scheduler) {
        this.signalPeriodMillis = signalPeriodMillis;
        this.scheduler = scheduler;
        this.dispatcherExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("Dispatcher"));
    }

    public abstract void dispatch();

    @Override
    protected void startUp() {
        this.dispatchFuture = this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.signal();
            }
            catch (Throwable t2) {
                log.error("Exception raised while signal dispatcher.", t2);
            }
        }, 0L, this.signalPeriodMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void shutDown() throws InterruptedException {
        if (null != this.dispatchFuture) {
            this.dispatchFuture.cancel(false);
        }
        this.dispatcherExecutor.shutdown();
        if (!ExecutorServices.awaitTerminated(this.dispatcherExecutor)) {
            log.error("[Bug] Failed to shutdown the batch dispatcher.");
        }
    }

    public void signal() {
        block3: {
            if (this.dispatchTaskInQueue.compareAndSet(false, true)) {
                try {
                    this.dispatcherExecutor.submit(new DispatchTask());
                }
                catch (Throwable t2) {
                    if (this.dispatcherExecutor.isShutdown()) break block3;
                    log.error("[Bug] Failed to submit dispatch task.", t2);
                }
            }
        }
    }

    class DispatchTask
    implements Runnable {
        DispatchTask() {
        }

        @Override
        public void run() {
            Dispatcher.this.dispatchTaskInQueue.compareAndSet(true, false);
            try {
                Dispatcher.this.dispatch();
            }
            catch (Throwable t2) {
                log.error("Exception raised while dispatching task", t2);
            }
        }
    }
}

