/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route;

import apache.rocketmq.v1.Resource;
import com.aliyun.openservices.ons.shaded.com.google.common.base.MoreObjects;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Objects;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Broker;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Endpoints;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Permission;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Partition {
    private final com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.Resource topicResource;
    private final Broker broker;
    private final int id;
    private final Permission permission;

    public Partition(apache.rocketmq.v1.Partition partition) {
        Resource resource = partition.getTopic();
        this.topicResource = new com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.Resource(resource.getResourceNamespace(), resource.getName());
        this.id = partition.getId();
        apache.rocketmq.v1.Permission perm = partition.getPermission();
        switch (perm) {
            case READ: {
                this.permission = Permission.READ;
                break;
            }
            case WRITE: {
                this.permission = Permission.WRITE;
                break;
            }
            case READ_WRITE: {
                this.permission = Permission.READ_WRITE;
                break;
            }
            default: {
                this.permission = Permission.NONE;
            }
        }
        String brokerName = partition.getBroker().getName();
        int brokerId = partition.getBroker().getId();
        apache.rocketmq.v1.Endpoints endpoints = partition.getBroker().getEndpoints();
        this.broker = new Broker(brokerName, brokerId, new Endpoints(endpoints));
    }

    public com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.Resource getTopicResource() {
        return this.topicResource;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public int getId() {
        return this.id;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return this.id == partition.id && Objects.equal(this.topicResource, partition.topicResource) && Objects.equal(this.broker, partition.broker) && this.permission == partition.permission;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.topicResource, this.broker, this.id, this.permission});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("topicResource", this.topicResource).add("broker", this.broker).add("id", this.id).add("permission", (Object)this.permission).toString();
    }
}

