/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route;

import com.aliyun.openservices.ons.shaded.com.google.common.base.MoreObjects;
import com.aliyun.openservices.ons.shaded.com.google.common.base.Objects;
import com.aliyun.openservices.ons.shaded.com.google.common.collect.ImmutableList;
import com.aliyun.openservices.ons.shaded.com.google.common.math.IntMath;
import com.aliyun.openservices.ons.shaded.commons.lang3.RandomUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ErrorCode;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ServerException;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Broker;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Endpoints;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Partition;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Permission;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TopicRouteData {
    public static final TopicRouteData EMPTY = new TopicRouteData(Collections.emptyList());
    private static final Logger log = LoggerFactory.getLogger(TopicRouteData.class);
    private final AtomicInteger index = new AtomicInteger(RandomUtils.nextInt());
    private final ImmutableList<Partition> partitions;

    public TopicRouteData(List<apache.rocketmq.v1.Partition> partitionList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (apache.rocketmq.v1.Partition partition : partitionList) {
            builder.add(new Partition(partition));
        }
        this.partitions = builder.build();
    }

    public Set<Endpoints> allEndpoints() {
        HashSet<Endpoints> endpointsSet = new HashSet<Endpoints>();
        for (Partition partition : this.partitions) {
            endpointsSet.add(partition.getBroker().getEndpoints());
        }
        return endpointsSet;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public Endpoints pickEndpointsToQueryAssignments() throws ServerException {
        int nextIndex = this.index.getAndIncrement();
        for (int i = 0; i < this.partitions.size(); ++i) {
            Partition partition;
            Broker broker;
            if (0 != (broker = (partition = (Partition)this.partitions.get(IntMath.mod(nextIndex++, this.partitions.size()))).getBroker()).getId() || Permission.NONE == partition.getPermission()) continue;
            return broker.getEndpoints();
        }
        log.error("No available endpoints, topicRouteData={}", (Object)this);
        throw new ServerException(ErrorCode.NO_PERMISSION, "No available endpoints to pick for query assignments");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicRouteData that = (TopicRouteData)o;
        return Objects.equal(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hashCode(this.partitions);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("partitions", this.partitions).toString();
    }
}

