/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace;

import com.aliyun.openservices.ons.shaded.grpc.netty.GrpcSslContexts;
import com.aliyun.openservices.ons.shaded.grpc.netty.NettyChannelBuilder;
import com.aliyun.openservices.ons.shaded.io.grpc.ClientInterceptor;
import com.aliyun.openservices.ons.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import com.aliyun.openservices.ons.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.Tracer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.OpenTelemetrySdk;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SdkTracerProvider;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.impl.ClientImpl;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.AuthInterceptor;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.IpNameResolverFactory;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.route.Endpoints;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace.TraceResource;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace.TracingMessageInterceptor;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.MetadataUtils;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MessageTracer {
    private static final Logger log = LoggerFactory.getLogger(MessageTracer.class);
    private static final String TRACER_INSTRUMENTATION_NAME = "org.apache.rocketmq.message";
    private static final long TRACE_EXPORTER_SCHEDULE_DELAY_MILLIS = 500L;
    private static final long TRACE_EXPORTER_RPC_TIMEOUT_MILLIS = 3000L;
    private static final int TRACE_EXPORTER_BATCH_SIZE = 2048;
    private static final int TRACE_EXPORTER_MAX_QUEUE_SIZE = 16384;
    private final ClientImpl clientImpl;
    private volatile Tracer tracer;
    private volatile Endpoints traceEndpoints;
    private volatile SdkTracerProvider tracerProvider;

    public MessageTracer(ClientImpl clientImpl) {
        this.clientImpl = clientImpl;
    }

    public void init() {
        if (this.clientImpl.isTracingEnabled()) {
            TracingMessageInterceptor interceptor = new TracingMessageInterceptor(this);
            this.clientImpl.registerMessageInterceptor(interceptor);
        }
    }

    public synchronized void refresh() {
        if (!this.clientImpl.isTracingEnabled()) {
            return;
        }
        List<Endpoints> candidates = this.clientImpl.getTraceCandidates();
        String clientId = this.clientImpl.getId();
        if (candidates.isEmpty()) {
            log.warn("No available message trace endpoints, clientId={}, existed endpoints={}", (Object)clientId, (Object)this.traceEndpoints);
            return;
        }
        if (null != this.traceEndpoints && candidates.contains(this.traceEndpoints)) {
            log.info("Message trace exporter endpoints remains the same, clientId={}, endpoints={}", (Object)clientId, (Object)this.traceEndpoints);
            return;
        }
        try {
            Collections.shuffle(candidates);
            Endpoints newTraceEndpoints = candidates.iterator().next();
            SslContext sslContext = GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            NettyChannelBuilder channelBuilder = (NettyChannelBuilder)NettyChannelBuilder.forTarget(newTraceEndpoints.getFacade()).sslContext(sslContext).intercept(new ClientInterceptor[]{new AuthInterceptor(this.clientImpl)});
            List<InetSocketAddress> socketAddresses = newTraceEndpoints.toSocketAddresses();
            if (null != socketAddresses) {
                IpNameResolverFactory tracingResolverFactory = new IpNameResolverFactory(socketAddresses);
                channelBuilder.nameResolverFactory(tracingResolverFactory);
            }
            OtlpGrpcSpanExporter exporter = OtlpGrpcSpanExporter.builder().setChannel(channelBuilder.build()).setTimeout(3000L, TimeUnit.MILLISECONDS).build();
            BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder(exporter).setScheduleDelay(500L, TimeUnit.MILLISECONDS).setMaxExportBatchSize(2048).setMaxQueueSize(16384).build();
            if (null != this.tracerProvider) {
                this.tracerProvider.shutdown();
            }
            Resource resource = TraceResource.get();
            this.tracerProvider = SdkTracerProvider.builder().addSpanProcessor(spanProcessor).setResource(resource).build();
            OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(this.tracerProvider).build();
            this.tracer = openTelemetry.getTracer(TRACER_INSTRUMENTATION_NAME, MetadataUtils.getVersion());
            log.info("Message trace exporter endpoints is updated, clientId={}, {} => {}", clientId, this.traceEndpoints, newTraceEndpoints);
            this.traceEndpoints = newTraceEndpoints;
        }
        catch (Throwable t2) {
            log.error("Exception raised while refreshing tracer, clientId={}", (Object)clientId, (Object)t2);
        }
    }

    public void shutdown() {
        log.info("Begin to shutdown the message tracer, clientId={}", (Object)this.clientImpl.getId());
        if (null != this.tracerProvider) {
            this.tracerProvider.shutdown();
        }
        log.info("Shutdown the message tracer successfully, clientId={}", (Object)this.clientImpl.getId());
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public ClientImpl getClientImpl() {
        return this.clientImpl;
    }
}

