/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.CreateHealthCheckResult;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.amazonaws.services.route53.model.DeleteHealthCheckRequest;
import com.amazonaws.services.route53.model.DeleteHealthCheckResult;
import com.amazonaws.services.route53.model.DeleteHostedZoneRequest;
import com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.GetHealthCheckRequest;
import com.amazonaws.services.route53.model.GetHealthCheckResult;
import com.amazonaws.services.route53.model.GetHostedZoneRequest;
import com.amazonaws.services.route53.model.GetHostedZoneResult;
import com.amazonaws.services.route53.model.ListHealthChecksRequest;
import com.amazonaws.services.route53.model.ListHealthChecksResult;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.transform.ChangeResourceRecordSetsRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ChangeResourceRecordSetsResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.CreateHealthCheckRequestMarshaller;
import com.amazonaws.services.route53.model.transform.CreateHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.CreateHostedZoneRequestMarshaller;
import com.amazonaws.services.route53.model.transform.CreateHostedZoneResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.DelegationSetNotAvailableExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHealthCheckRequestMarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHostedZoneRequestMarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHostedZoneResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.GetChangeRequestMarshaller;
import com.amazonaws.services.route53.model.transform.GetChangeResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.GetHealthCheckRequestMarshaller;
import com.amazonaws.services.route53.model.transform.GetHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.GetHostedZoneRequestMarshaller;
import com.amazonaws.services.route53.model.transform.GetHostedZoneResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.HealthCheckAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.HealthCheckInUseExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.HostedZoneAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.HostedZoneNotEmptyExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.IncompatibleVersionExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.InvalidChangeBatchExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.InvalidDomainNameExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.ListHealthChecksRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ListHealthChecksResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.ListHostedZonesRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ListHostedZonesResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.ListResourceRecordSetsRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ListResourceRecordSetsResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.NoSuchChangeExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.NoSuchHealthCheckExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.NoSuchHostedZoneExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.PriorRequestNotCompleteExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.TooManyHealthChecksExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.TooManyHostedZonesExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonRoute53Client
extends AmazonWebServiceClient
implements AmazonRoute53 {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonRoute53Client() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonRoute53Client(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonRoute53Client(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonRoute53Client(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonRoute53Client(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonRoute53Client(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonRoute53Client(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new NoSuchChangeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyHealthChecksExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HostedZoneAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyHostedZonesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HostedZoneNotEmptyExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new IncompatibleVersionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HealthCheckAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchHealthCheckExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PriorRequestNotCompleteExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HealthCheckInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DelegationSetNotAvailableExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidInputExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidChangeBatchExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchHostedZoneExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDomainNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("route53.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/route53/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHealthCheckResult getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getHealthCheckRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetHealthCheckRequest> request = null;
        Response<GetHealthCheckResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetHealthCheckRequestMarshaller().marshall(getHealthCheckRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetHealthCheckResultStaxUnmarshaller(), executionContext);
            GetHealthCheckResult getHealthCheckResult = response.getAwsResponse();
            return getHealthCheckResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHostedZoneResult getHostedZone(GetHostedZoneRequest getHostedZoneRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getHostedZoneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetHostedZoneRequest> request = null;
        Response<GetHostedZoneResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetHostedZoneRequestMarshaller().marshall(getHostedZoneRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetHostedZoneResultStaxUnmarshaller(), executionContext);
            GetHostedZoneResult getHostedZoneResult = response.getAwsResponse();
            return getHostedZoneResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHostedZoneResult deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHostedZoneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteHostedZoneRequest> request = null;
        Response<DeleteHostedZoneResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteHostedZoneRequestMarshaller().marshall(deleteHostedZoneRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DeleteHostedZoneResultStaxUnmarshaller(), executionContext);
            DeleteHostedZoneResult deleteHostedZoneResult = response.getAwsResponse();
            return deleteHostedZoneResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChangeResult getChange(GetChangeRequest getChangeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChangeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetChangeRequest> request = null;
        Response<GetChangeResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetChangeRequestMarshaller().marshall(getChangeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetChangeResultStaxUnmarshaller(), executionContext);
            GetChangeResult getChangeResult = response.getAwsResponse();
            return getChangeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHostedZonesResult listHostedZones(ListHostedZonesRequest listHostedZonesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHostedZonesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListHostedZonesRequest> request = null;
        Response<ListHostedZonesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListHostedZonesRequestMarshaller().marshall(listHostedZonesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListHostedZonesResultStaxUnmarshaller(), executionContext);
            ListHostedZonesResult listHostedZonesResult = response.getAwsResponse();
            return listHostedZonesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHostedZoneResult createHostedZone(CreateHostedZoneRequest createHostedZoneRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHostedZoneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateHostedZoneRequest> request = null;
        Response<CreateHostedZoneResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateHostedZoneRequestMarshaller().marshall(createHostedZoneRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateHostedZoneResultStaxUnmarshaller(), executionContext);
            CreateHostedZoneResult createHostedZoneResult = response.getAwsResponse();
            return createHostedZoneResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangeResourceRecordSetsResult changeResourceRecordSets(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(changeResourceRecordSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ChangeResourceRecordSetsRequest> request = null;
        Response<ChangeResourceRecordSetsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ChangeResourceRecordSetsRequestMarshaller().marshall(changeResourceRecordSetsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ChangeResourceRecordSetsResultStaxUnmarshaller(), executionContext);
            ChangeResourceRecordSetsResult changeResourceRecordSetsResult = response.getAwsResponse();
            return changeResourceRecordSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHealthCheckResult createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHealthCheckRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateHealthCheckRequest> request = null;
        Response<CreateHealthCheckResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateHealthCheckRequestMarshaller().marshall(createHealthCheckRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateHealthCheckResultStaxUnmarshaller(), executionContext);
            CreateHealthCheckResult createHealthCheckResult = response.getAwsResponse();
            return createHealthCheckResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHealthChecksResult listHealthChecks(ListHealthChecksRequest listHealthChecksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHealthChecksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListHealthChecksRequest> request = null;
        Response<ListHealthChecksResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListHealthChecksRequestMarshaller().marshall(listHealthChecksRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListHealthChecksResultStaxUnmarshaller(), executionContext);
            ListHealthChecksResult listHealthChecksResult = response.getAwsResponse();
            return listHealthChecksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHealthCheckResult deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHealthCheckRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteHealthCheckRequest> request = null;
        Response<DeleteHealthCheckResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteHealthCheckRequestMarshaller().marshall(deleteHealthCheckRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DeleteHealthCheckResultStaxUnmarshaller(), executionContext);
            DeleteHealthCheckResult deleteHealthCheckResult = response.getAwsResponse();
            return deleteHealthCheckResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceRecordSetsResult listResourceRecordSets(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResourceRecordSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListResourceRecordSetsRequest> request = null;
        Response<ListResourceRecordSetsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListResourceRecordSetsRequestMarshaller().marshall(listResourceRecordSetsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListResourceRecordSetsResultStaxUnmarshaller(), executionContext);
            ListResourceRecordSetsResult listResourceRecordSetsResult = response.getAwsResponse();
            return listResourceRecordSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHostedZonesResult listHostedZones() throws AmazonServiceException, AmazonClientException {
        return this.listHostedZones(new ListHostedZonesRequest());
    }

    @Override
    public ListHealthChecksResult listHealthChecks() throws AmazonServiceException, AmazonClientException {
        return this.listHealthChecks(new ListHealthChecksRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

