/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal.velocystream;

import com.arangodb.ArangoDBException;
import com.arangodb.async.internal.velocystream.VstConnectionAsync;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.internal.velocystream.VstCommunication;
import com.arangodb.internal.velocystream.internal.AuthenticationRequest;
import com.arangodb.internal.velocystream.internal.Message;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VstCommunicationAsync
extends VstCommunication<CompletableFuture<Response>, VstConnectionAsync> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VstCommunicationAsync.class);

    private VstCommunicationAsync(HostHandler hostHandler, Integer timeout, String user, String password, Boolean useSsl, SSLContext sslContext, ArangoSerialization util, Integer chunksize, Integer maxConnections, Long connectionTtl) {
        super(timeout, user, password, useSsl, sslContext, util, chunksize, hostHandler);
    }

    @Override
    protected CompletableFuture<Response> execute(Request request, VstConnectionAsync connection) {
        CompletableFuture<Response> rfuture = new CompletableFuture<Response>();
        try {
            Message message = this.createMessage(request);
            this.send(message, connection).whenComplete((m, ex) -> {
                if (m != null) {
                    Response response;
                    try {
                        response = this.createResponse((Message)m);
                    }
                    catch (VPackParserException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        rfuture.completeExceptionally(e);
                        return;
                    }
                    try {
                        this.checkError(response);
                    }
                    catch (ArangoDBRedirectException e) {
                        String location = e.getLocation();
                        HostDescription redirectHost = HostUtils.createFromLocation(location);
                        this.hostHandler.closeCurrentOnError();
                        this.hostHandler.fail();
                        ((CompletableFuture)this.execute(request, new HostHandle().setHost(redirectHost))).whenComplete((v, err) -> {
                            if (v != null) {
                                rfuture.complete((Response)v);
                            } else if (err != null) {
                                rfuture.completeExceptionally((Throwable)err);
                            } else {
                                rfuture.cancel(true);
                            }
                        });
                        return;
                    }
                    catch (ArangoDBException e) {
                        rfuture.completeExceptionally(e);
                    }
                    rfuture.complete(response);
                } else if (ex != null) {
                    LOGGER.error(ex.getMessage(), ex);
                    rfuture.completeExceptionally((Throwable)ex);
                } else {
                    rfuture.cancel(true);
                }
            });
        }
        catch (VPackException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rfuture.completeExceptionally(e);
        }
        return rfuture;
    }

    private CompletableFuture<Message> send(Message message, VstConnectionAsync connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Send Message (id=%s, head=%s, body=%s)", message.getId(), message.getHead(), message.getBody() != null ? message.getBody() : "{}"));
        }
        return connection.write(message, (Collection)this.buildChunks(message));
    }

    @Override
    protected void authenticate(VstConnectionAsync connection) {
        Response response;
        try {
            response = this.execute((Request)new AuthenticationRequest(this.user, this.password != null ? this.password : "", "plain"), connection).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ArangoDBException(e);
        }
        this.checkError(response);
    }

    public static class Builder {
        private final HostHandler hostHandler;
        private Integer timeout;
        private Long connectionTtl;
        private String user;
        private String password;
        private Boolean useSsl;
        private SSLContext sslContext;
        private Integer chunksize;
        private Integer maxConnections;

        public Builder(HostHandler hostHandler) {
            this.hostHandler = hostHandler;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder chunksize(Integer chunksize) {
            this.chunksize = chunksize;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder connectionTtl(Long connectionTtl) {
            this.connectionTtl = connectionTtl;
            return this;
        }

        public VstCommunicationAsync build(ArangoSerialization util) {
            return new VstCommunicationAsync(this.hostHandler, this.timeout, this.user, this.password, this.useSsl, this.sslContext, util, this.chunksize, this.maxConnections, this.connectionTtl);
        }
    }
}

