/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.cursor;

import com.arangodb.ArangoCursor;
import com.arangodb.ArangoIterator;
import com.arangodb.entity.CursorEntity;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.velocypack.VPackSlice;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArangoCursorIterator<T>
implements ArangoIterator<T> {
    private CursorEntity result;
    private Iterator<VPackSlice> arrayIterator;
    private final ArangoCursor<T> cursor;
    private final InternalArangoDatabase<?, ?> db;
    private final ArangoCursorExecute execute;

    protected ArangoCursorIterator(ArangoCursor<T> cursor, ArangoCursorExecute execute, InternalArangoDatabase<?, ?> db, CursorEntity result) {
        this.cursor = cursor;
        this.execute = execute;
        this.db = db;
        this.result = result;
        this.arrayIterator = result.getResult().arrayIterator();
    }

    public CursorEntity getResult() {
        return this.result;
    }

    @Override
    public boolean hasNext() {
        return this.arrayIterator.hasNext() || this.result.getHasMore() != false;
    }

    @Override
    public T next() {
        if (!this.arrayIterator.hasNext() && this.result.getHasMore().booleanValue()) {
            this.result = this.execute.next(this.cursor.getId(), this.result.getMeta());
            this.arrayIterator = this.result.getResult().arrayIterator();
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.deserialize(this.arrayIterator.next(), this.cursor.getType());
    }

    protected <R> R deserialize(VPackSlice result, Class<R> type) {
        return (R)this.db.util(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(result, type);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

