/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.mapping;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.jackson.dataformat.velocypack.internal.VPackParser;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.internal.util.DateUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public class VPackDeserializers {
    public static final JsonDeserializer<VPackSlice> VPACK = new JsonDeserializer<VPackSlice>(){

        public VPackSlice deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (p instanceof VPackParser) {
                VPackSlice vpack = ((VPackParser)p).getVPack();
                if (vpack.isArray() || vpack.isObject()) {
                    for (int i = 0; i < vpack.size() + 1; ++i) {
                        p.nextToken();
                    }
                }
                return vpack;
            }
            return new VPackSlice(p.getBinaryValue());
        }
    };
    public static final JsonDeserializer<Date> UTIL_DATE = new JsonDeserializer<Date>(){

        public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return DateUtil.parse((String)p.getValueAsString());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
    };
    public static final JsonDeserializer<java.sql.Date> SQL_DATE = new JsonDeserializer<java.sql.Date>(){

        public java.sql.Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return new java.sql.Date(DateUtil.parse((String)p.getValueAsString()).getTime());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
    };
    public static final JsonDeserializer<Timestamp> SQL_TIMESTAMP = new JsonDeserializer<Timestamp>(){

        public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return new Timestamp(DateUtil.parse((String)p.getValueAsString()).getTime());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
    };
    public static final JsonDeserializer<BaseDocument> BASE_DOCUMENT = new JsonDeserializer<BaseDocument>(){

        public BaseDocument deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new BaseDocument((Map)p.readValueAs(Map.class));
        }
    };
    public static final JsonDeserializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = new JsonDeserializer<BaseEdgeDocument>(){

        public BaseEdgeDocument deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new BaseEdgeDocument((Map)p.readValueAs(Map.class));
        }
    };
}

