/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.HostSet;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedHostResolver
implements HostResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedHostResolver.class);
    private final HostSet hosts;
    private final Integer maxConnections;
    private final ConnectionFactory connectionFactory;
    private long lastUpdate;
    private final Integer acquireHostListInterval;
    private ArangoExecutorSync executor;
    private ArangoSerialization arangoSerialization;

    public ExtendedHostResolver(List<Host> hosts, Integer maxConnections, ConnectionFactory connectionFactory, Integer acquireHostListInterval) {
        this.acquireHostListInterval = acquireHostListInterval;
        this.hosts = new HostSet(hosts);
        this.maxConnections = maxConnections;
        this.connectionFactory = connectionFactory;
        this.lastUpdate = 0L;
    }

    @Override
    public void init(ArangoExecutorSync executor, ArangoSerialization arangoSerialization) {
        this.executor = executor;
        this.arangoSerialization = arangoSerialization;
    }

    @Override
    public HostSet resolve(boolean initial, boolean closeConnections) {
        if (!initial && this.isExpired()) {
            this.lastUpdate = System.currentTimeMillis();
            Collection<String> endpoints = this.resolveFromServer();
            LOGGER.debug("Resolve " + endpoints.size() + " Endpoints");
            LOGGER.debug("Endpoints " + Arrays.deepToString(endpoints.toArray()));
            if (!endpoints.isEmpty()) {
                this.hosts.markAllForDeletion();
            }
            for (String endpoint : endpoints) {
                LOGGER.debug("Create HOST from " + endpoint);
                if (endpoint.matches(".*://.+:[0-9]+")) {
                    HostDescription description;
                    String[] s = endpoint.replaceAll(".*://", "").split(":");
                    if (s.length == 2) {
                        description = new HostDescription(s[0], Integer.parseInt(s[1]));
                        this.hosts.addHost(HostUtils.createHost(description, this.maxConnections, this.connectionFactory));
                        continue;
                    }
                    if (s.length == 4) {
                        description = new HostDescription("127.0.0.1", Integer.parseInt(s[3]));
                        this.hosts.addHost(HostUtils.createHost(description, this.maxConnections, this.connectionFactory));
                        continue;
                    }
                    LOGGER.warn("Skip Endpoint (Missing Port)" + endpoint);
                    continue;
                }
                LOGGER.warn("Skip Endpoint (Format)" + endpoint);
            }
            this.hosts.clearAllMarkedForDeletion();
        }
        return this.hosts;
    }

    private Collection<String> resolveFromServer() throws ArangoDBException {
        List<String> response;
        try {
            response = this.executor.execute(new Request("_system", RequestType.GET, "/_api/cluster/endpoints"), response1 -> {
                List endpoints;
                VPackSlice field = response1.getBody().get("endpoints");
                if (field.isNone()) {
                    endpoints = Collections.emptyList();
                } else {
                    Collection tmp = (Collection)this.arangoSerialization.deserialize(field, (Type)((Object)Collection.class));
                    endpoints = new ArrayList();
                    for (Map map : tmp) {
                        endpoints.add(map.get("endpoint"));
                    }
                }
                return endpoints;
            }, null);
        }
        catch (ArangoDBException e) {
            Integer responseCode = e.getResponseCode();
            if (responseCode != null && (responseCode == 403 || responseCode == 501)) {
                response = Collections.emptyList();
            }
            throw e;
        }
        return response;
    }

    private boolean isExpired() {
        return System.currentTimeMillis() > this.lastUpdate + (long)this.acquireHostListInterval.intValue();
    }
}

