/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocypack;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.entity.CollectionStatus;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.License;
import com.arangodb.entity.LogLevel;
import com.arangodb.entity.MinReplicationFactor;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryExecutionState;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.AnalyzerType;
import com.arangodb.entity.arangosearch.ArangoSearchCompression;
import com.arangodb.entity.arangosearch.ArangoSearchProperties;
import com.arangodb.entity.arangosearch.ArangoSearchPropertiesEntity;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.ConsolidationPolicy;
import com.arangodb.entity.arangosearch.ConsolidationType;
import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.entity.arangosearch.PrimarySort;
import com.arangodb.entity.arangosearch.StoreValuesType;
import com.arangodb.entity.arangosearch.StoredValue;
import com.arangodb.entity.arangosearch.analyzer.AQLAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.DelimiterAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.GeoJSONAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.GeoPointAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.IdentityAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.NGramAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.NormAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.PipelineAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.SearchAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.StemAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.StopwordsAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.TextAnalyzer;
import com.arangodb.model.CollectionSchema;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Response;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VPackDeserializers {
    private static final Logger LOGGER = LoggerFactory.getLogger(VPackDeserializers.class);
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final VPackDeserializer<Response> RESPONSE = (parent, vpack, context) -> {
        Response response = new Response();
        response.setVersion(vpack.get(0).getAsInt());
        response.setType(vpack.get(1).getAsInt());
        response.setResponseCode(vpack.get(2).getAsInt());
        if (vpack.size() > 3) {
            response.setMeta((Map)context.deserialize(vpack.get(3), Map.class));
        }
        return response;
    };
    public static final VPackDeserializer<CollectionType> COLLECTION_TYPE = (parent, vpack, context) -> CollectionType.fromType(vpack.getAsInt());
    public static final VPackDeserializer<CollectionStatus> COLLECTION_STATUS = (parent, vpack, context) -> CollectionStatus.fromStatus(vpack.getAsInt());
    public static final VPackDeserializer<BaseDocument> BASE_DOCUMENT = (parent, vpack, context) -> new BaseDocument((Map)context.deserialize(vpack, Map.class));
    public static final VPackDeserializer<SearchAnalyzer> SEARCH_ANALYZER = (parent, vpack, context) -> {
        AnalyzerType type = (AnalyzerType)((Object)((Object)context.deserialize(vpack.get("type"), AnalyzerType.class)));
        switch (type) {
            case identity: {
                return (SearchAnalyzer)context.deserialize(vpack, IdentityAnalyzer.class);
            }
            case text: {
                return (SearchAnalyzer)context.deserialize(vpack, TextAnalyzer.class);
            }
            case ngram: {
                return (SearchAnalyzer)context.deserialize(vpack, NGramAnalyzer.class);
            }
            case delimiter: {
                return (SearchAnalyzer)context.deserialize(vpack, DelimiterAnalyzer.class);
            }
            case stem: {
                return (SearchAnalyzer)context.deserialize(vpack, StemAnalyzer.class);
            }
            case norm: {
                return (SearchAnalyzer)context.deserialize(vpack, NormAnalyzer.class);
            }
            case pipeline: {
                return (SearchAnalyzer)context.deserialize(vpack, PipelineAnalyzer.class);
            }
            case stopwords: {
                return (SearchAnalyzer)context.deserialize(vpack, StopwordsAnalyzer.class);
            }
            case aql: {
                return (SearchAnalyzer)context.deserialize(vpack, AQLAnalyzer.class);
            }
            case geojson: {
                return (SearchAnalyzer)context.deserialize(vpack, GeoJSONAnalyzer.class);
            }
            case geopoint: {
                return (SearchAnalyzer)context.deserialize(vpack, GeoPointAnalyzer.class);
            }
        }
        throw new IllegalArgumentException("Unknown analyzer type: " + (Object)((Object)type));
    };
    public static final VPackDeserializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = (parent, vpack, context) -> new BaseEdgeDocument((Map)context.deserialize(vpack, Map.class));
    public static final VPackDeserializer<Date> DATE_STRING = (parent, vpack, context) -> {
        try {
            return new SimpleDateFormat(DATE_TIME_FORMAT).parse(vpack.getAsString());
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("got ParseException for date string: " + vpack.getAsString());
            }
            return null;
        }
    };
    public static final VPackDeserializer<LogLevel> LOG_LEVEL = (parent, vpack, context) -> LogLevel.fromLevel(vpack.getAsInt());
    public static final VPackDeserializer<License> LICENSE = (parent, vpack, context) -> License.valueOf(vpack.getAsString().toUpperCase());
    public static final VPackDeserializer<Permissions> PERMISSIONS = (parent, vpack, context) -> Permissions.valueOf(vpack.getAsString().toUpperCase());
    public static final VPackDeserializer<QueryExecutionState> QUERY_EXECUTION_STATE = (parent, vpack, context) -> QueryExecutionState.valueOf(vpack.getAsString().toUpperCase().replaceAll(" ", "_"));
    public static final VPackDeserializer<ReplicationFactor> REPLICATION_FACTOR = (parent, vpack, context) -> {
        ReplicationFactor replicationFactor = new ReplicationFactor();
        if (vpack.isString() && vpack.getAsString().equals("satellite")) {
            replicationFactor.setSatellite(true);
        } else {
            replicationFactor.setReplicationFactor(vpack.getAsInt());
        }
        return replicationFactor;
    };
    public static final VPackDeserializer<MinReplicationFactor> MIN_REPLICATION_FACTOR = (parent, vpack, context) -> {
        MinReplicationFactor minReplicationFactor = new MinReplicationFactor();
        minReplicationFactor.setMinReplicationFactor(vpack.getAsInt());
        return minReplicationFactor;
    };
    public static final VPackDeserializer<ViewType> VIEW_TYPE = (parent, vpack, context) -> "arangosearch".equals(vpack.getAsString()) ? ViewType.ARANGO_SEARCH : ViewType.valueOf(vpack.getAsString().toUpperCase());
    public static final VPackDeserializer<ArangoSearchProperties> ARANGO_SEARCH_PROPERTIES = (parent, vpack, context) -> {
        VPackSlice storedValues;
        VPackSlice primarySortCompression;
        VPackSlice primarySorts;
        VPackSlice links;
        VPackSlice consolidationPolicy;
        VPackSlice cleanupIntervalStep;
        VPackSlice commitIntervalMsec;
        ArangoSearchProperties properties = new ArangoSearchProperties();
        VPackSlice consolidationIntervalMsec = vpack.get("consolidationIntervalMsec");
        if (consolidationIntervalMsec.isInteger()) {
            properties.setConsolidationIntervalMsec(consolidationIntervalMsec.getAsLong());
        }
        if ((commitIntervalMsec = vpack.get("commitIntervalMsec")).isInteger()) {
            properties.setCommitIntervalMsec(commitIntervalMsec.getAsLong());
        }
        if ((cleanupIntervalStep = vpack.get("cleanupIntervalStep")).isInteger()) {
            properties.setCleanupIntervalStep(cleanupIntervalStep.getAsLong());
        }
        if ((consolidationPolicy = vpack.get("consolidationPolicy")).isObject()) {
            properties.setConsolidationPolicy((ConsolidationPolicy)context.deserialize(consolidationPolicy, ConsolidationPolicy.class));
        }
        if ((links = vpack.get("links")).isObject()) {
            Iterator collectionIterator = links.objectIterator();
            while (collectionIterator.hasNext()) {
                VPackSlice fields;
                VPackSlice storeValues;
                VPackSlice trackListPositions;
                VPackSlice includeAllFields;
                Map.Entry entry = (Map.Entry)collectionIterator.next();
                VPackSlice value = (VPackSlice)entry.getValue();
                CollectionLink link = CollectionLink.on((String)entry.getKey());
                VPackSlice analyzers = value.get("analyzers");
                if (analyzers.isArray()) {
                    Iterator analyzerIterator = analyzers.arrayIterator();
                    while (analyzerIterator.hasNext()) {
                        link.analyzers(((VPackSlice)analyzerIterator.next()).getAsString());
                    }
                }
                if ((includeAllFields = value.get("includeAllFields")).isBoolean()) {
                    link.includeAllFields(includeAllFields.getAsBoolean());
                }
                if ((trackListPositions = value.get("trackListPositions")).isBoolean()) {
                    link.trackListPositions(trackListPositions.getAsBoolean());
                }
                if ((storeValues = value.get("storeValues")).isString()) {
                    link.storeValues(StoreValuesType.valueOf(storeValues.getAsString().toUpperCase()));
                }
                if ((fields = value.get("fields")).isObject()) {
                    Iterator fieldsIterator = fields.objectIterator();
                    while (fieldsIterator.hasNext()) {
                        link.fields(VPackDeserializers.deserializeField((Map.Entry)fieldsIterator.next()));
                    }
                }
                properties.addLink(link);
            }
        }
        if ((primarySorts = vpack.get("primarySort")).isArray()) {
            Iterator primarySortsIterator = primarySorts.arrayIterator();
            while (primarySortsIterator.hasNext()) {
                VPackSlice entry = (VPackSlice)primarySortsIterator.next();
                if (!entry.isObject() || !entry.get("field").isString() || !entry.get("asc").isBoolean()) continue;
                PrimarySort primarySort = PrimarySort.on(entry.get("field").getAsString());
                primarySort.ascending(entry.get("asc").getAsBoolean());
                properties.addPrimarySort(primarySort);
            }
        }
        if ((primarySortCompression = vpack.get("primarySortCompression")).isString()) {
            properties.setPrimarySortCompression(ArangoSearchCompression.valueOf(primarySortCompression.getAsString()));
        }
        if ((storedValues = vpack.get("storedValues")).isArray()) {
            Iterator storedValueIterator = storedValues.arrayIterator();
            while (storedValueIterator.hasNext()) {
                VPackSlice entry = (VPackSlice)storedValueIterator.next();
                if (!entry.isObject()) continue;
                VPackSlice fields = entry.get("fields");
                VPackSlice compression = entry.get("compression");
                if (!fields.isArray() || !compression.isString()) continue;
                Iterator fieldsIterator = fields.arrayIterator();
                ArrayList<String> fieldsList = new ArrayList<String>();
                fieldsIterator.forEachRemaining(it -> fieldsList.add(it.getAsString()));
                properties.addStoredValues(new StoredValue(fieldsList, ArangoSearchCompression.valueOf(compression.getAsString())));
            }
        }
        return properties;
    };
    public static final VPackDeserializer<ArangoSearchPropertiesEntity> ARANGO_SEARCH_PROPERTIES_ENTITY = (parent, vpack, context) -> {
        ViewEntity entity = (ViewEntity)context.deserialize(vpack, ViewEntity.class);
        ArangoSearchProperties properties = (ArangoSearchProperties)context.deserialize(vpack, ArangoSearchProperties.class);
        return new ArangoSearchPropertiesEntity(entity.getId(), entity.getName(), entity.getType(), properties);
    };
    public static final VPackDeserializer<ConsolidationPolicy> CONSOLIDATE = (parent, vpack, context) -> {
        VPackSlice type = vpack.get("type");
        if (type.isString()) {
            VPackSlice segmentThreshold;
            ConsolidationPolicy consolidate = ConsolidationPolicy.of(ConsolidationType.valueOf(type.getAsString().toUpperCase()));
            VPackSlice threshold = vpack.get("threshold");
            if (threshold.isNumber()) {
                consolidate.threshold(threshold.getAsDouble());
            }
            if ((segmentThreshold = vpack.get("segmentThreshold")).isInteger()) {
                consolidate.segmentThreshold(segmentThreshold.getAsLong());
            }
            return consolidate;
        }
        return null;
    };
    public static final VPackDeserializer<CollectionSchema> COLLECTION_VALIDATION = (parent, vpack, context) -> {
        VPackParser parser = new VPackParser.Builder().build();
        CollectionSchema collectionValidation = new CollectionSchema();
        collectionValidation.setLevel(CollectionSchema.Level.of(vpack.get("level").getAsString()));
        collectionValidation.setRule(parser.toJson(vpack.get("rule"), true));
        collectionValidation.setMessage(vpack.get("message").getAsString());
        return collectionValidation;
    };

    protected static FieldLink deserializeField(Map.Entry<String, VPackSlice> field) {
        VPackSlice fields;
        VPackSlice storeValues;
        VPackSlice trackListPositions;
        VPackSlice includeAllFields;
        VPackSlice value = field.getValue();
        FieldLink link = FieldLink.on(field.getKey());
        VPackSlice analyzers = value.get("analyzers");
        if (analyzers.isArray()) {
            Iterator analyzerIterator = analyzers.arrayIterator();
            while (analyzerIterator.hasNext()) {
                link.analyzers(((VPackSlice)analyzerIterator.next()).getAsString());
            }
        }
        if ((includeAllFields = value.get("includeAllFields")).isBoolean()) {
            link.includeAllFields(includeAllFields.getAsBoolean());
        }
        if ((trackListPositions = value.get("trackListPositions")).isBoolean()) {
            link.trackListPositions(trackListPositions.getAsBoolean());
        }
        if ((storeValues = value.get("storeValues")).isString()) {
            link.storeValues(StoreValuesType.valueOf(storeValues.getAsString().toUpperCase()));
        }
        if ((fields = value.get("fields")).isObject()) {
            Iterator fieldsIterator = fields.objectIterator();
            while (fieldsIterator.hasNext()) {
                link.fields(VPackDeserializers.deserializeField((Map.Entry)fieldsIterator.next()));
            }
        }
        return link;
    }
}

