/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.DataSerializable;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SysException;
import com.atomikos.jdbc.nonxa.JtaAwareNonXaConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;

public class AtomikosNonXAParticipant
implements Participant,
Serializable,
DataSerializable {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosNonXAParticipant.class);
    private static final long serialVersionUID = -771461092384746954L;
    private boolean readOnly;
    private List<HeuristicMessage> heuristicMessages;
    private transient JtaAwareNonXaConnection connection;

    public AtomikosNonXAParticipant() {
    }

    public AtomikosNonXAParticipant(JtaAwareNonXaConnection connection, String name) {
        this.heuristicMessages = new ArrayList<HeuristicMessage>();
        this.connection = connection;
        this.heuristicMessages.add((HeuristicMessage)new StringHeuristicMessage("Non-XA resource '" + name + "': warning: this resource does not support two-phase commit"));
    }

    public boolean recover() throws SysException {
        return true;
    }

    public void setCascadeList(Dictionary allParticipants) throws SysException {
    }

    public void setGlobalSiblingCount(int count) {
    }

    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        int ret = 1;
        return ret;
    }

    public HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        if (this.isRecovered()) {
            if (!this.readOnly) {
                throw new HeurRollbackException(this.getHeuristicMessages());
            }
        } else {
            try {
                this.connection.transactionTerminated(true);
            }
            catch (Exception e) {
                LOGGER.logWarning("Error in non-XA commit", (Throwable)e);
                throw new HeurMixedException(this.getHeuristicMessages());
            }
        }
        return this.getHeuristicMessages();
    }

    private boolean isRecovered() {
        return this.connection == null;
    }

    public HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        if (!this.isRecovered()) {
            try {
                this.connection.transactionTerminated(false);
            }
            catch (Exception e) {
                LOGGER.logWarning("Error in non-XA rollback", (Throwable)e);
                throw new HeurMixedException(this.getHeuristicMessages());
            }
        }
        return this.getHeuristicMessages();
    }

    public void forget() {
    }

    public HeuristicMessage[] getHeuristicMessages() {
        HeuristicMessage[] ret = new HeuristicMessage[]{};
        ret = this.heuristicMessages.toArray(ret);
        return ret;
    }

    public String getURI() {
        return null;
    }

    void addHeuristicMessage(HeuristicMessage msg) {
        if (msg != null) {
            this.heuristicMessages.add(msg);
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeBoolean(this.readOnly);
        out.writeInt(this.heuristicMessages.size());
        for (HeuristicMessage heuristicMessage : this.heuristicMessages) {
            out.writeUTF(heuristicMessage.toString());
        }
    }

    public void readData(DataInput in) throws IOException {
        this.readOnly = in.readBoolean();
        int nbMessages = in.readInt();
        this.heuristicMessages = new ArrayList<HeuristicMessage>(nbMessages);
        for (int i = 0; i < nbMessages; ++i) {
            this.heuristicMessages.add((HeuristicMessage)new StringHeuristicMessage(in.readUTF()));
        }
    }
}

