/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.http;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Protocol;
import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.Signer;
import com.baidubce.http.BceCloseableHttpResponse;
import com.baidubce.http.BceHttpResponse;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.IdleConnectionReaper;
import com.baidubce.http.RetryPolicy;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.util.HttpUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BceHttpClient {
    private static final Logger requestLogger = LoggerFactory.getLogger((String)"com.baidubce.request");
    private static final Logger logger = LoggerFactory.getLogger(BceHttpClient.class);
    protected CloseableHttpClient httpClient;
    protected CloseableHttpAsyncClient httpAsyncClient;
    protected BceClientConfiguration config;
    protected Signer signer;
    private HttpClientConnectionManager connectionManager;
    private NHttpClientConnectionManager nioConnectionManager;
    private RequestConfig.Builder requestConfigBuilder;
    private CredentialsProvider credentialsProvider;
    private HttpHost proxyHttpHost;
    private boolean isHttpAsyncPutEnabled = false;
    private static ConcurrentHashMap<String, CloseableHttpAsyncClient> asyncClientMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, NHttpClientConnectionManager> managerMap = new ConcurrentHashMap();

    public BceHttpClient(BceClientConfiguration config, Signer signer) {
        Preconditions.checkNotNull((Object)config, (Object)"config should not be null.");
        Preconditions.checkNotNull((Object)signer, (Object)"signer should not be null.");
        this.config = config;
        this.signer = signer;
        this.connectionManager = this.createHttpClientConnectionManager();
        this.httpClient = this.createHttpClient(this.connectionManager);
        IdleConnectionReaper.registerConnectionManager(this.connectionManager);
        this.requestConfigBuilder = RequestConfig.custom();
        this.requestConfigBuilder.setConnectTimeout(config.getConnectionTimeoutInMillis());
        this.requestConfigBuilder.setStaleConnectionCheckEnabled(true);
        this.requestConfigBuilder.setRedirectsEnabled(config.isRedirectsEnabled());
        if (config.getLocalAddress() != null) {
            this.requestConfigBuilder.setLocalAddress(config.getLocalAddress());
        }
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            this.proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            this.requestConfigBuilder.setProxy(this.proxyHttpHost);
            this.credentialsProvider = new BasicCredentialsProvider();
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
        }
    }

    public BceHttpClient(BceClientConfiguration config, Signer signer, boolean isHttpAsyncPutEnabled) {
        this(config, signer);
        if (isHttpAsyncPutEnabled) {
            try {
                this.nioConnectionManager = this.createNHttpClientConnectionManager();
                this.httpAsyncClient = this.createHttpAsyncClient(this.nioConnectionManager);
                this.httpAsyncClient.start();
                this.isHttpAsyncPutEnabled = true;
            }
            catch (IOReactorException e) {
                this.isHttpAsyncPutEnabled = false;
            }
        } else {
            this.isHttpAsyncPutEnabled = false;
        }
    }

    public <T extends AbstractBceResponse> T execute(InternalRequest request, Class<T> responseClass, HttpResponseHandler[] responseHandlers) {
        request.addHeader("User-Agent", this.config.getUserAgent());
        BceCredentials credentials = this.config.getCredentials();
        if (request.getCredentials() != null) {
            credentials = request.getCredentials();
        }
        long delayForNextRetryInMillis = 0L;
        int attempt = 1;
        while (true) {
            HttpRequestBase httpRequest = null;
            CloseableHttpResponse httpResponse = null;
            try {
                if (credentials != null) {
                    this.signer.sign(request, credentials);
                }
                requestLogger.debug("Sending Request: {}", (Object)request);
                httpRequest = this.createHttpRequest(request);
                HttpClientContext httpContext = this.createHttpContext(request);
                if (this.isHttpAsyncPutEnabled && httpRequest.getMethod().equals("PUT")) {
                    Future future = this.httpAsyncClient.execute(HttpAsyncMethods.create((HttpUriRequest)httpRequest), (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), (HttpContext)httpContext, null);
                    httpResponse = new BceCloseableHttpResponse((HttpResponse)future.get());
                } else {
                    httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
                }
                HttpUtils.printRequest(httpRequest);
                BceHttpResponse bceHttpResponse = new BceHttpResponse(httpResponse);
                AbstractBceResponse response = (AbstractBceResponse)responseClass.newInstance();
                for (HttpResponseHandler handler : responseHandlers) {
                    if (handler.handle(bceHttpResponse, response)) break;
                }
                return (T)response;
            }
            catch (Exception e) {
                BceClientException bce;
                if (logger.isInfoEnabled()) {
                    logger.info("Unable to execute HTTP request", (Throwable)e);
                }
                if ((delayForNextRetryInMillis = this.getDelayBeforeNextRetryInMillis(httpRequest, bce = e instanceof BceClientException ? (BceClientException)e : new BceClientException("Unable to execute HTTP request", e), attempt, this.config.getRetryPolicy())) < 0L) {
                    throw bce;
                }
                logger.debug("Retriable error detected, will retry in {} ms, attempt number: {}", (Object)delayForNextRetryInMillis, (Object)attempt);
                try {
                    Thread.sleep(delayForNextRetryInMillis);
                }
                catch (InterruptedException e1) {
                    throw new BceClientException("Delay interrupted", e1);
                }
                if (request.getContent() != null) {
                    request.getContent().restart();
                }
                if (httpResponse != null) {
                    try {
                        InputStream instream;
                        HttpEntity entity = httpResponse.getEntity();
                        if (entity != null && entity.isStreaming() && (instream = entity.getContent()) != null) {
                            instream.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.debug("Fail to consume entity.", (Throwable)e1);
                        try {
                            httpResponse.close();
                        }
                        catch (IOException e2) {
                            logger.debug("Fail to close connection.", (Throwable)e2);
                        }
                    }
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            logger.debug("Fail to close httpClient", (Throwable)e);
        }
        this.connectionManager.shutdown();
    }

    protected long getDelayBeforeNextRetryInMillis(HttpRequestBase method, BceClientException exception, int attempt, RetryPolicy retryPolicy) {
        HttpEntity entity;
        int retries = attempt - 1;
        int maxErrorRetry = retryPolicy.getMaxErrorRetry();
        if (retries >= maxErrorRetry) {
            return -1L;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            logger.debug("Entity not repeatable, stop retrying");
            return -1L;
        }
        return Math.min(retryPolicy.getMaxDelayInMillis(), retryPolicy.getDelayBeforeNextRetryInMillis(exception, retries));
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        SSLConnectionSocketFactory sslSocketFactory;
        PlainConnectionSocketFactory socketFactory = PlainConnectionSocketFactory.getSocketFactory();
        try {
            sslSocketFactory = new SSLConnectionSocketFactory(SSLContext.getDefault(), SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BceClientException("Fail to create SSLConnectionSocketFactory", e);
        }
        Registry registry = RegistryBuilder.create().register(Protocol.HTTP.toString(), (Object)socketFactory).register(Protocol.HTTPS.toString(), (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setDefaultMaxPerRoute(this.config.getMaxConnections());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.config.getSocketTimeoutInMillis()).setTcpNoDelay(true).build());
        connectionManager.setMaxTotal(this.config.getMaxConnections());
        return connectionManager;
    }

    protected NHttpClientConnectionManager createNHttpClientConnectionManager() throws IOReactorException {
        if (managerMap.containsKey(this.config.getEndpoint())) {
            return managerMap.get(this.config.getEndpoint());
        }
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(IOReactorConfig.custom().setSoReuseAddress(true).setSoTimeout(this.config.getSocketTimeoutInMillis()).setTcpNoDelay(true).build());
        PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        connectionManager.setDefaultMaxPerRoute(this.config.getMaxConnections());
        connectionManager.setMaxTotal(this.config.getMaxConnections());
        managerMap.putIfAbsent(this.config.getEndpoint(), (NHttpClientConnectionManager)connectionManager);
        return connectionManager;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(connectionManager).disableAutomaticRetries();
        int socketBufferSizeInBytes = this.config.getSocketBufferSizeInBytes();
        if (socketBufferSizeInBytes > 0) {
            builder.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(socketBufferSizeInBytes).build());
        }
        return builder.build();
    }

    protected CloseableHttpAsyncClient createHttpAsyncClient(NHttpClientConnectionManager connectionManager) {
        if (asyncClientMap.containsKey(this.config.getEndpoint())) {
            return asyncClientMap.get(this.config.getEndpoint());
        }
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setConnectionManager(connectionManager);
        int socketBufferSizeInBytes = this.config.getSocketBufferSizeInBytes();
        if (socketBufferSizeInBytes > 0) {
            builder.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(socketBufferSizeInBytes).build());
        }
        CloseableHttpAsyncClient client = builder.build();
        asyncClientMap.putIfAbsent(this.config.getEndpoint(), client);
        return client;
    }

    protected HttpRequestBase createHttpRequest(InternalRequest request) {
        HttpGet httpRequest;
        String uri = request.getUri().toASCIIString();
        String encodedParams = HttpUtils.getCanonicalQueryString(request.getParameters(), false);
        if (encodedParams.length() > 0) {
            uri = uri + "?" + encodedParams;
        }
        long contentLength = -1L;
        String contentLengthString = request.getHeaders().get("Content-Length");
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
        }
        if (request.getHttpMethod() == HttpMethodName.GET) {
            httpRequest = new HttpGet(uri);
        } else if (request.getHttpMethod() == HttpMethodName.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            httpRequest = putMethod;
            if (request.getContent() != null) {
                putMethod.setEntity((HttpEntity)new InputStreamEntity((InputStream)request.getContent(), contentLength));
            }
        } else if (request.getHttpMethod() == HttpMethodName.POST) {
            HttpPost postMethod = new HttpPost(uri);
            httpRequest = postMethod;
            if (request.getContent() != null) {
                postMethod.setEntity((HttpEntity)new InputStreamEntity((InputStream)request.getContent(), contentLength));
            }
        } else if (request.getHttpMethod() == HttpMethodName.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (request.getHttpMethod() == HttpMethodName.HEAD) {
            httpRequest = new HttpHead(uri);
        } else {
            throw new BceClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
        }
        httpRequest.addHeader("Host", HttpUtils.generateHostHeader(request.getUri()));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        Preconditions.checkNotNull((Object)httpRequest.getFirstHeader("Content-Type"), (Object)"Content-Type not set");
        return httpRequest;
    }

    protected HttpClientContext createHttpContext(InternalRequest request) {
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(this.requestConfigBuilder.setExpectContinueEnabled(request.isExpectContinueEnabled()).setSocketTimeout(this.config.getSocketTimeoutInMillis()).build());
        if (this.credentialsProvider != null) {
            context.setCredentialsProvider(this.credentialsProvider);
        }
        if (this.config.isProxyPreemptiveAuthenticationEnabled()) {
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(this.proxyHttpHost, (AuthScheme)new BasicScheme());
            context.setAuthCache((AuthCache)authCache);
        }
        return context;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }
}

