/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bcc;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.bcc.BccClientConfiguration;
import com.baidubce.services.bcc.model.Billing;
import com.baidubce.services.bcc.model.Reservation;
import com.baidubce.services.bcc.model.TagModel;
import com.baidubce.services.bcc.model.asp.AspAction;
import com.baidubce.services.bcc.model.asp.AttachAspRequest;
import com.baidubce.services.bcc.model.asp.CreateAspRequest;
import com.baidubce.services.bcc.model.asp.CreateAspResponse;
import com.baidubce.services.bcc.model.asp.DeleteAspRequest;
import com.baidubce.services.bcc.model.asp.DetachAspRequest;
import com.baidubce.services.bcc.model.asp.GetAspRequest;
import com.baidubce.services.bcc.model.asp.GetAspResponse;
import com.baidubce.services.bcc.model.asp.ListAspsRequest;
import com.baidubce.services.bcc.model.asp.ListAspsResponse;
import com.baidubce.services.bcc.model.asp.UpdateAspRequest;
import com.baidubce.services.bcc.model.deployset.CreateDeploySetRequest;
import com.baidubce.services.bcc.model.deployset.CreateDeploySetResponse;
import com.baidubce.services.bcc.model.deployset.DeleteDeploySetRequest;
import com.baidubce.services.bcc.model.deployset.DeploySetAction;
import com.baidubce.services.bcc.model.deployset.ListDeploySetResponse;
import com.baidubce.services.bcc.model.deployset.UpdateDeploySetRequest;
import com.baidubce.services.bcc.model.flavor.ListBccBidFlavorResponse;
import com.baidubce.services.bcc.model.flavor.ListBccFlavorSpecResponse;
import com.baidubce.services.bcc.model.flavor.ListFlavorSpecRequest;
import com.baidubce.services.bcc.model.image.CancelRemoteCopyImageRequest;
import com.baidubce.services.bcc.model.image.CreateImageRequest;
import com.baidubce.services.bcc.model.image.CreateImageResponse;
import com.baidubce.services.bcc.model.image.DeleteImageRequest;
import com.baidubce.services.bcc.model.image.GetImageRequest;
import com.baidubce.services.bcc.model.image.GetImageResponse;
import com.baidubce.services.bcc.model.image.ImageAction;
import com.baidubce.services.bcc.model.image.ListImagesRequest;
import com.baidubce.services.bcc.model.image.ListImagesResponse;
import com.baidubce.services.bcc.model.image.ListOsRequest;
import com.baidubce.services.bcc.model.image.ListOsResponse;
import com.baidubce.services.bcc.model.image.ListSharedUserRequest;
import com.baidubce.services.bcc.model.image.ListSharedUserResponse;
import com.baidubce.services.bcc.model.image.RemoteCopyImageRequest;
import com.baidubce.services.bcc.model.image.ShareImageRequest;
import com.baidubce.services.bcc.model.image.UnShareImageRequest;
import com.baidubce.services.bcc.model.instance.BccPriceRequest;
import com.baidubce.services.bcc.model.instance.BccPriceResponse;
import com.baidubce.services.bcc.model.instance.BindSecurityGroupRequest;
import com.baidubce.services.bcc.model.instance.BindTagsRequest;
import com.baidubce.services.bcc.model.instance.CancelBidOrderRequest;
import com.baidubce.services.bcc.model.instance.CancelBidOrderResponse;
import com.baidubce.services.bcc.model.instance.ChangeInstanceSubnetRequest;
import com.baidubce.services.bcc.model.instance.ChangeToPrepaidRequest;
import com.baidubce.services.bcc.model.instance.ChangeToPrepaidResponse;
import com.baidubce.services.bcc.model.instance.CreateInstanceRequest;
import com.baidubce.services.bcc.model.instance.CreateInstanceResponse;
import com.baidubce.services.bcc.model.instance.FpgaCardType;
import com.baidubce.services.bcc.model.instance.GetBidInstancePriceRequest;
import com.baidubce.services.bcc.model.instance.GetBidInstancePriceResponse;
import com.baidubce.services.bcc.model.instance.GetInstanceRequest;
import com.baidubce.services.bcc.model.instance.GetInstanceResponse;
import com.baidubce.services.bcc.model.instance.GetInstanceVncRequest;
import com.baidubce.services.bcc.model.instance.GetInstanceVncResponse;
import com.baidubce.services.bcc.model.instance.GpuCardType;
import com.baidubce.services.bcc.model.instance.InstanceAction;
import com.baidubce.services.bcc.model.instance.InstanceType;
import com.baidubce.services.bcc.model.instance.ListGetInstanceNoChargeRequest;
import com.baidubce.services.bcc.model.instance.ListInstanceSpecsRequest;
import com.baidubce.services.bcc.model.instance.ListInstanceSpecsResponse;
import com.baidubce.services.bcc.model.instance.ListInstancesRequest;
import com.baidubce.services.bcc.model.instance.ListInstancesResponse;
import com.baidubce.services.bcc.model.instance.ModifyInstanceAttributesRequest;
import com.baidubce.services.bcc.model.instance.ModifyInstanceDescRequest;
import com.baidubce.services.bcc.model.instance.ModifyInstanceHostnameRequest;
import com.baidubce.services.bcc.model.instance.ModifyInstancePasswordRequest;
import com.baidubce.services.bcc.model.instance.PurchaseReservedInstanceRequeset;
import com.baidubce.services.bcc.model.instance.RebootInstanceRequest;
import com.baidubce.services.bcc.model.instance.RebuildBatchInstanceRequest;
import com.baidubce.services.bcc.model.instance.RebuildInstanceRequest;
import com.baidubce.services.bcc.model.instance.ReleaseInstanceByPostRequest;
import com.baidubce.services.bcc.model.instance.ReleaseInstanceRequest;
import com.baidubce.services.bcc.model.instance.ResizeInstanceRequest;
import com.baidubce.services.bcc.model.instance.StartInstanceRequest;
import com.baidubce.services.bcc.model.instance.StopInstanceRequest;
import com.baidubce.services.bcc.model.instance.UnbindSecurityGroupRequest;
import com.baidubce.services.bcc.model.instance.UnbindTagsRequest;
import com.baidubce.services.bcc.model.keypair.KeypairAction;
import com.baidubce.services.bcc.model.keypair.KeypairAttachRequest;
import com.baidubce.services.bcc.model.keypair.KeypairCreateRequest;
import com.baidubce.services.bcc.model.keypair.KeypairCreateResponse;
import com.baidubce.services.bcc.model.keypair.KeypairDeleteRequest;
import com.baidubce.services.bcc.model.keypair.KeypairDetachRequest;
import com.baidubce.services.bcc.model.keypair.KeypairDetailRequest;
import com.baidubce.services.bcc.model.keypair.KeypairImportRequest;
import com.baidubce.services.bcc.model.keypair.KeypairListRequest;
import com.baidubce.services.bcc.model.keypair.KeypairListResponse;
import com.baidubce.services.bcc.model.keypair.KeypairModel;
import com.baidubce.services.bcc.model.keypair.KeypairRenameRequest;
import com.baidubce.services.bcc.model.keypair.KeypairResponse;
import com.baidubce.services.bcc.model.keypair.KeypairUpdateDescRequest;
import com.baidubce.services.bcc.model.securitygroup.CreateSecurityGroupRequest;
import com.baidubce.services.bcc.model.securitygroup.CreateSecurityGroupResponse;
import com.baidubce.services.bcc.model.securitygroup.DeleteSecurityGroupRequest;
import com.baidubce.services.bcc.model.securitygroup.ListSecurityGroupsRequest;
import com.baidubce.services.bcc.model.securitygroup.ListSecurityGroupsResponse;
import com.baidubce.services.bcc.model.securitygroup.SecurityGroupAction;
import com.baidubce.services.bcc.model.securitygroup.SecurityGroupRuleOperateRequest;
import com.baidubce.services.bcc.model.snapshot.CreateSnapshotRequest;
import com.baidubce.services.bcc.model.snapshot.CreateSnapshotResponse;
import com.baidubce.services.bcc.model.snapshot.DeleteSnapshotRequest;
import com.baidubce.services.bcc.model.snapshot.GetSnapshotRequest;
import com.baidubce.services.bcc.model.snapshot.GetSnapshotResponse;
import com.baidubce.services.bcc.model.snapshot.ListSnapchainRequest;
import com.baidubce.services.bcc.model.snapshot.ListSnapchainResponse;
import com.baidubce.services.bcc.model.snapshot.ListSnapshotsRequest;
import com.baidubce.services.bcc.model.snapshot.ListSnapshotsResponse;
import com.baidubce.services.bcc.model.volume.AttachVolumeRequest;
import com.baidubce.services.bcc.model.volume.AttachVolumeResponse;
import com.baidubce.services.bcc.model.volume.AutoRenewVolumeRequest;
import com.baidubce.services.bcc.model.volume.CancelAutoRenewVolumeRequest;
import com.baidubce.services.bcc.model.volume.CreateVolumeRequest;
import com.baidubce.services.bcc.model.volume.CreateVolumeResponse;
import com.baidubce.services.bcc.model.volume.DetachVolumeRequest;
import com.baidubce.services.bcc.model.volume.GetVolumeRequest;
import com.baidubce.services.bcc.model.volume.GetVolumeResponse;
import com.baidubce.services.bcc.model.volume.ListVolumesRequest;
import com.baidubce.services.bcc.model.volume.ListVolumesResponse;
import com.baidubce.services.bcc.model.volume.ModifyCdsAttrRequest;
import com.baidubce.services.bcc.model.volume.ModifyVolumeChargeRequest;
import com.baidubce.services.bcc.model.volume.ModifyVolumeChargeTypeRequest;
import com.baidubce.services.bcc.model.volume.PurchaseReservedVolumeRequest;
import com.baidubce.services.bcc.model.volume.ReleaseVolumeRequest;
import com.baidubce.services.bcc.model.volume.RenameVolumeRequest;
import com.baidubce.services.bcc.model.volume.ResizeVolumeRequest;
import com.baidubce.services.bcc.model.volume.RollbackVolumeRequest;
import com.baidubce.services.bcc.model.volume.VolumeAction;
import com.baidubce.services.bcc.model.zone.ListZonesResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BccClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BccClient.class);
    private static final String VERSION = "v2";
    private static final String INSTANCE_PREFIX = "instance";
    private static final String INSTANCE_BY_SPEC_PREFIX = "instanceBySpec";
    private static final String BID = "bid";
    private static final String FLAVOR_SPEC_PREFIX = "flavorSpec";
    private static final String VOLUME_PREFIX = "volume";
    private static final String IMAGE_PREFIX = "image";
    private static final String OS_PREFIX = "os";
    private static final String SECURITYGROUP_PREFIX = "securityGroup";
    private static final String SNAPSHOT_PREFIX = "snapshot";
    private static final String ZONE = "zone";
    private static final String TAG = "tag";
    private static final String ASP = "asp";
    private static final String KEYPAIR = "keypair";
    private static final String SHARED_USER = "sharedUsers";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String MARKER = "marker";
    private static final String MAX_KEYS = "maxKeys";
    private static final String ZONE_NAME = "zoneName";
    private static final String INTERNAL_IP = "internalIp";
    private static final String DEDICATED_HOST_ID = "dedicatedHostId";
    private static final String IMAGE_TYPE = "imageType";
    private static final String VOLUME_NAME = "volumeName";
    private static final String VPC_ID = "vpcId";
    private static final String FLAVOR_SPEC = "flavorSpec";
    private static final String PRICE = "price";
    private static final String DEPLOYSET = "deployset";
    private static final String CHAIN = "chain";
    private static final String BID_FLAVOR = "bidFlavor";
    private static final String BID_PRICE = "bidPrice";
    private static final String CANCEL_BID_ORDER = "cancelBidOrder";
    private static final String NO_CHARGE = "noCharge";
    private static final String REBUILD = "rebuild";
    private static final String SUBNET_PREFIX = "subnet";
    private static final String CHANGE_SUBNET = "changeSubnet";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String CHANGETAGS_NULL_ERROR_MESSAGE = "request changeTags should not be null.";
    private static final String INSTANCEID_MESSAGE_KEY = "instanceId";
    private static final String INSTANCE_TYPE_MESSAGE_KEY = "instanceType";
    private static final String ORDER_ID_MESSAGE_KEY = "orderId";
    private static final String TAGKEY_MESSAGE_KEY = "tagKey";
    private static final String ADMINPASS_MESSAGE_KEY = "adminPass";
    private static final String IMAGEID_MESSAGE_KEY = "imageId";
    private static final String NAME_MESSAGE_KEY = "name";
    private static final String DESC_MESSAGE_KEY = "desc";
    private static final String SECURITYGROUPID_MESSAGE_KEY = "securityGroupId";
    private static final String VOLUMEID_MESSAGE_KEY = "volumeId";
    private static final String SNAPSHOTID_MESSAGE_KEY = "snapshotId";
    private static final String IMAGENAME_MESSAGE_KEY = "imageName";
    private static final String SNAPSHOTNAME_MESSAGE_KEY = "snapshotName";
    private static final String ASPNAME_MESSAGE_KEY = "aspName";
    private static final String ASPID_MESSAGE_KEY = "aspId";
    private static final String KEYPAIR_ID_MESSAGE_KEY = "keypair";
    private static final String SUBNETID_MESSAGE_KEY = "subnetId";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] bcc_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BccClient() {
        this(new BccClientConfiguration());
    }

    public BccClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, bcc_handlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    private String aes128WithFirst16Char(String content, String privateKey) throws GeneralSecurityException {
        byte[] crypted = null;
        SecretKeySpec skey = new SecretKeySpec(privateKey.substring(0, 16).getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        crypted = cipher.doFinal(content.getBytes());
        return new String(Hex.encodeHex((byte[])crypted));
    }

    private Billing generateDefaultBilling() {
        Billing billing = new Billing();
        billing.setPaymentTiming("Postpaid");
        return billing;
    }

    private Billing generateDefaultBillingWithReservation() {
        Billing billing = new Billing();
        billing.withReservation(new Reservation().withReservationLength(1));
        return billing;
    }

    public CreateInstanceResponse createInstance(CreateInstanceRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        if (null != request.getTags() && !request.getTags().isEmpty()) {
            for (TagModel tag : request.getTags()) {
                Validate.checkStringNotEmpty(tag.getTagKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TAGKEY_MESSAGE_KEY));
            }
        }
        if (InstanceType.G1.name().equalsIgnoreCase(request.getInstanceType())) {
            Validate.checkIsTrue(GpuCardType.isExists(request.getGpuCard()), "invalid gpgCard parameter");
            Validate.checkIsTrue(request.getCardCount() > 0, "invalid cardCount parameter");
        }
        if (InstanceType.F1.name().equalsIgnoreCase(request.getInstanceType())) {
            Validate.checkIsTrue(FpgaCardType.isExists(request.getFpgaCard()), "invalid fpgaCard parameter");
            Validate.checkIsTrue(request.getCardCount() > 0, "invalid cardCount parameter");
        }
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        if (!Strings.isNullOrEmpty((String)request.getAdminPass())) {
            BceCredentials credentials = this.config.getCredentials();
            if (internalRequest.getCredentials() != null) {
                credentials = internalRequest.getCredentials();
            }
            try {
                request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
            }
            catch (GeneralSecurityException e) {
                throw new BceClientException("Encryption procedure exception", e);
            }
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateInstanceResponse.class);
    }

    public CreateInstanceResponse createInstanceBySpec(CreateInstanceRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        if (null != request.getTags() && !request.getTags().isEmpty()) {
            for (TagModel tag : request.getTags()) {
                Validate.checkStringNotEmpty(tag.getTagKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TAGKEY_MESSAGE_KEY));
            }
        }
        if (StringUtils.isEmpty((CharSequence)request.getSpec())) {
            if (InstanceType.G1.name().equalsIgnoreCase(request.getInstanceType())) {
                Validate.checkIsTrue(GpuCardType.isExists(request.getGpuCard()), "invalid gpgCard parameter");
                Validate.checkIsTrue(request.getCardCount() > 0, "invalid cardCount parameter");
            }
            if (InstanceType.F1.name().equalsIgnoreCase(request.getInstanceType())) {
                Validate.checkIsTrue(FpgaCardType.isExists(request.getFpgaCard()), "invalid fpgaCard parameter");
                Validate.checkIsTrue(request.getCardCount() > 0, "invalid cardCount parameter");
            }
        }
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_BY_SPEC_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        if (!Strings.isNullOrEmpty((String)request.getAdminPass())) {
            BceCredentials credentials = this.config.getCredentials();
            if (internalRequest.getCredentials() != null) {
                credentials = internalRequest.getCredentials();
            }
            try {
                request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
            }
            catch (GeneralSecurityException e) {
                throw new BceClientException("Encryption procedure exception", e);
            }
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateInstanceResponse.class);
    }

    public CreateInstanceResponse createBidInstance(CreateInstanceRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling().withPaymentTiming("bidding"));
        }
        if (null != request.getTags() && !request.getTags().isEmpty()) {
            for (TagModel tag : request.getTags()) {
                Validate.checkStringNotEmpty(tag.getTagKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TAGKEY_MESSAGE_KEY));
            }
        }
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX, BID);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        if (!Strings.isNullOrEmpty((String)request.getAdminPass())) {
            BceCredentials credentials = this.config.getCredentials();
            if (internalRequest.getCredentials() != null) {
                credentials = internalRequest.getCredentials();
            }
            try {
                request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
            }
            catch (GeneralSecurityException e) {
                throw new BceClientException("Encryption procedure exception", e);
            }
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateInstanceResponse.class);
    }

    public BccPriceResponse getPriceBySpec(BccPriceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX, PRICE);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BccPriceResponse.class);
    }

    public ListInstancesResponse listInstances() {
        return this.listInstances(new ListInstancesRequest());
    }

    public ListInstancesResponse listInstances(ListInstancesRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getInternalIp())) {
            internalRequest.addParameter(INTERNAL_IP, request.getInternalIp());
        }
        if (!Strings.isNullOrEmpty((String)request.getDedicatedHostId())) {
            internalRequest.addParameter(DEDICATED_HOST_ID, request.getDedicatedHostId());
        }
        if (!Strings.isNullOrEmpty((String)request.getZoneName())) {
            internalRequest.addParameter(ZONE_NAME, request.getZoneName());
        }
        return this.invokeHttpClient(internalRequest, ListInstancesResponse.class);
    }

    public ListBccFlavorSpecResponse listFlavorSpec(ListFlavorSpecRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, "flavorSpec");
        if (!Strings.isNullOrEmpty((String)request.getZoneName())) {
            internalRequest.addParameter(ZONE_NAME, request.getZoneName());
        }
        return this.invokeHttpClient(internalRequest, ListBccFlavorSpecResponse.class);
    }

    public ListBccBidFlavorResponse listBidFlavor() {
        return this.listBidFlavor(new AbstractBceRequest(){

            @Override
            public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
                return null;
            }
        });
    }

    private ListBccBidFlavorResponse listBidFlavor(AbstractBceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX, BID_FLAVOR);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ListBccBidFlavorResponse.class);
    }

    public GetBidInstancePriceResponse getBidInstancePrice(GetBidInstancePriceRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null != request.getTags() && !request.getTags().isEmpty()) {
            for (TagModel tag : request.getTags()) {
                Validate.checkStringNotEmpty(tag.getTagKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TAGKEY_MESSAGE_KEY));
            }
        }
        Validate.checkStringNotEmpty(request.getInstanceType(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCE_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX, BID_PRICE);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        if (!Strings.isNullOrEmpty((String)request.getAdminPass())) {
            BceCredentials credentials = this.config.getCredentials();
            if (internalRequest.getCredentials() != null) {
                credentials = internalRequest.getCredentials();
            }
            try {
                request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
            }
            catch (GeneralSecurityException e) {
                throw new BceClientException("Encryption procedure exception", e);
            }
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, GetBidInstancePriceResponse.class);
    }

    public CancelBidOrderResponse cancelBidOrder(String oderId) {
        return this.cancelBidOrder(new CancelBidOrderRequest().withOrderId(oderId));
    }

    public CancelBidOrderResponse cancelBidOrder(CancelBidOrderRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getOrderId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ORDER_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX, CANCEL_BID_ORDER);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CancelBidOrderResponse.class);
    }

    public ListInstancesResponse getInstanceNoChargeList(ListGetInstanceNoChargeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, NO_CHARGE);
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getInternalIp())) {
            internalRequest.addParameter(INTERNAL_IP, request.getInternalIp());
        }
        if (!Strings.isNullOrEmpty((String)request.getZoneName())) {
            internalRequest.addParameter(ZONE_NAME, request.getZoneName());
        }
        return this.invokeHttpClient(internalRequest, ListInstancesResponse.class);
    }

    public GetInstanceResponse getInstance(String instanceId) {
        return this.getInstance(new GetInstanceRequest().withInstanceId(instanceId));
    }

    public GetInstanceResponse getInstance(GetInstanceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, request.getInstanceId());
        return this.invokeHttpClient(internalRequest, GetInstanceResponse.class);
    }

    public ChangeToPrepaidResponse changeToPrepaid(ChangeToPrepaidRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.toPrepay.name(), null);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ChangeToPrepaidResponse.class);
    }

    public void startInstance(String instanceId) {
        this.startInstance(new StartInstanceRequest().withInstanceId(instanceId));
    }

    public void startInstance(StartInstanceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.start.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void stopInstance(String instanceId) {
        this.stopInstance(new StopInstanceRequest().withInstanceId(instanceId).withForceStop(false).withStopWithNoCharge(false));
    }

    public void stopInstance(String instanceId, boolean forceStop) {
        this.stopInstance(new StopInstanceRequest().withInstanceId(instanceId).withForceStop(forceStop).withStopWithNoCharge(false));
    }

    public void stopInstance(String instanceId, boolean forceStop, boolean stopWithNoCharge) {
        this.stopInstance(new StopInstanceRequest().withInstanceId(instanceId).withForceStop(forceStop).withStopWithNoCharge(stopWithNoCharge));
    }

    public void stopInstance(StopInstanceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.stop.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void rebootInstance(String instanceId) {
        this.rebootInstance(new RebootInstanceRequest().withInstanceId(instanceId).withForceStop(false));
    }

    public void rebootInstance(String instanceId, boolean forceStop) {
        this.rebootInstance(new RebootInstanceRequest().withInstanceId(instanceId).withForceStop(forceStop));
    }

    public void rebootInstance(RebootInstanceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.reboot.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyInstancePassword(String instanceId, String adminPass) throws BceClientException {
        this.modifyInstancePassword(new ModifyInstancePasswordRequest().withInstanceId(instanceId).withAdminPass(adminPass));
    }

    public void modifyInstancePassword(ModifyInstancePasswordRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAdminPass(), StringFormatUtils.checkEmptyExceptionMessageFormat(ADMINPASS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.changePass.name(), null);
        BceCredentials credentials = this.config.getCredentials();
        if (internalRequest.getCredentials() != null) {
            credentials = internalRequest.getCredentials();
        }
        try {
            request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
        }
        catch (GeneralSecurityException e) {
            throw new BceClientException("Encryption procedure exception", e);
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyInstanceHostname(String instanceId, String hostname, boolean isReboot) throws BceClientException {
        this.modifyInstanceHostname(new ModifyInstanceHostnameRequest().withInstanceId(instanceId).withHostname(hostname).withIsReboot(isReboot));
    }

    public void modifyInstanceHostname(ModifyInstanceHostnameRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getHostname(), StringFormatUtils.checkEmptyExceptionMessageFormat(ADMINPASS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.changeHostname.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyInstanceAttributes(ModifyInstanceAttributesRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.modifyAttribute.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyInstanceDesc(ModifyInstanceDescRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getDesc(), StringFormatUtils.checkEmptyExceptionMessageFormat(DESC_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.modifyDesc.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void rebuildInstance(String instanceId, String imageId, String adminPass) throws BceClientException {
        this.rebuildInstance(new RebuildInstanceRequest().withInstanceId(instanceId).withImageId(imageId).withAdminPass(adminPass));
    }

    public void rebuildInstance(String instanceId, String imageId, String adminPass, String keypairId) throws BceClientException {
        this.rebuildInstance(new RebuildInstanceRequest().withInstanceId(instanceId).withImageId(imageId).withAdminPass(adminPass).withKeypairId(keypairId));
    }

    public void rebuildInstance(RebuildInstanceRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAdminPass(), StringFormatUtils.checkEmptyExceptionMessageFormat(ADMINPASS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.rebuild.name(), null);
        BceCredentials credentials = this.config.getCredentials();
        if (internalRequest.getCredentials() != null) {
            credentials = internalRequest.getCredentials();
        }
        try {
            request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
        }
        catch (GeneralSecurityException e) {
            throw new BceClientException("Encryption procedure exception", e);
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void rebuildBatchInstance(List<String> instanceIds, String imageId, String adminPass) throws BceClientException {
        this.rebuildBatchInstance(new RebuildBatchInstanceRequest().withInstanceIds(instanceIds).withImageId(imageId).withAdminPass(adminPass));
    }

    public void rebuildBatchInstance(List<String> instanceIds, String imageId, String adminPass, String keypairId) throws BceClientException {
        this.rebuildBatchInstance(new RebuildBatchInstanceRequest().withInstanceIds(instanceIds).withImageId(imageId).withAdminPass(adminPass).withKeypairId(keypairId));
    }

    public void rebuildBatchInstance(RebuildBatchInstanceRequest request) throws BceClientException {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (request.getInstanceIds().size() == 0) {
            throw new IllegalArgumentException("request instanceIds should not be empty.");
        }
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAdminPass(), StringFormatUtils.checkEmptyExceptionMessageFormat(ADMINPASS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, REBUILD);
        BceCredentials credentials = this.config.getCredentials();
        if (internalRequest.getCredentials() != null) {
            credentials = internalRequest.getCredentials();
        }
        try {
            request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
        }
        catch (GeneralSecurityException e) {
            throw new BceClientException("Encryption procedure exception", e);
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseInstance(String instanceId) {
        this.releaseInstance(new ReleaseInstanceRequest().withInstanceId(instanceId));
    }

    public void releaseInstance(ReleaseInstanceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, INSTANCE_PREFIX, request.getInstanceId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseInstanceByPost(String instanceId, boolean relatedReleaseFlag, boolean deleteCdsSnapshotFlag) {
        this.releaseInstanceByPost(new ReleaseInstanceByPostRequest().withInstanceId(instanceId).withRelatedReleaseFlag(relatedReleaseFlag).withDeleteCdsSnapshotFlag(deleteCdsSnapshotFlag));
    }

    public void releaseInstanceByPost(ReleaseInstanceByPostRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX, request.getInstanceId());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateInstanceSubnet(String instanceId, String subnetId, boolean reboot) {
        this.updateInstanceSubnet(new ChangeInstanceSubnetRequest().withInstanceId(instanceId).withSubnetId(subnetId).withReboot(reboot));
    }

    public void updateInstanceSubnet(ChangeInstanceSubnetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSubnetId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SUBNETID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SUBNET_PREFIX, CHANGE_SUBNET);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void resizeInstance(ResizeInstanceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        if (request.getCpuCount() <= 0) {
            throw new IllegalArgumentException("request cpuCount should be positive.");
        }
        if (request.getMemoryCapacityInGB() <= 0) {
            throw new IllegalArgumentException("request memoryCapacityInGB should be positive.");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.resize.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void resizeInstanceBySpec(ResizeInstanceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_BY_SPEC_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.resize.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindInstanceToSecurityGroup(String instanceId, String securityGroupId) {
        this.bindInstanceToSecurityGroup(new BindSecurityGroupRequest().withInstanceId(instanceId).withSecurityGroupId(securityGroupId));
    }

    public void bindInstanceToSecurityGroup(BindSecurityGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITYGROUPID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.bind.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unbindInstanceFromSecurityGroup(String instanceId, String securityGroupId) {
        this.unbindInstanceFromSecurityGroup(new UnbindSecurityGroupRequest().withInstanceId(instanceId).withSecurityGroupId(securityGroupId));
    }

    public void unbindInstanceFromSecurityGroup(UnbindSecurityGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITYGROUPID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.unbind.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindInstanceToTags(String instanceId, List<TagModel> changeTags) {
        this.bindInstanceToTags(new BindTagsRequest().withInstanceId(instanceId).withChangeTags(changeTags));
    }

    public void bindInstanceToTags(BindTagsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        if (null != request.getChangeTags() && !request.getChangeTags().isEmpty()) {
            for (TagModel tag : request.getChangeTags()) {
                Validate.checkStringNotEmpty(tag.getTagKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TAGKEY_MESSAGE_KEY));
            }
        } else {
            throw new IllegalArgumentException(CHANGETAGS_NULL_ERROR_MESSAGE);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId(), TAG);
        internalRequest.addParameter("bind", null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unbindInstanceFromTags(String instanceId, List<TagModel> changeTags) {
        this.unbindInstanceFromTags(new UnbindTagsRequest().withInstanceId(instanceId).withChangeTags(changeTags));
    }

    public void unbindInstanceFromTags(UnbindTagsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        if (null != request.getChangeTags() && !request.getChangeTags().isEmpty()) {
            for (TagModel tag : request.getChangeTags()) {
                Validate.checkStringNotEmpty(tag.getTagKey(), StringFormatUtils.checkEmptyExceptionMessageFormat(TAGKEY_MESSAGE_KEY));
            }
        } else {
            throw new IllegalArgumentException(CHANGETAGS_NULL_ERROR_MESSAGE);
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId(), TAG);
        internalRequest.addParameter("unbind", null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetInstanceVncResponse getInstanceVnc(String instanceId) {
        return this.getInstanceVnc(new GetInstanceVncRequest().withInstanceId(instanceId));
    }

    public GetInstanceVncResponse getInstanceVnc(GetInstanceVncRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, request.getInstanceId(), "vnc");
        return this.invokeHttpClient(internalRequest, GetInstanceVncResponse.class);
    }

    public void purchaseReservedInstance(String instanceId, int reservationLength, String reservationTimeUnit) {
        this.purchaseReservedInstance(new PurchaseReservedInstanceRequeset().withInstanceId(instanceId).withBilling(new Billing().withReservation(new Reservation().withReservationLength(reservationLength).withReservationTimeUnit(reservationTimeUnit))));
    }

    public void purchaseReservedInstance(String instanceId, int reservationLength, String reservationTimeUnit, String relatedRenewFlagType) {
        this.purchaseReservedInstance(new PurchaseReservedInstanceRequeset().withInstanceId(instanceId).withBilling(new Billing().withReservation(new Reservation().withReservationLength(reservationLength).withReservationTimeUnit(reservationTimeUnit))).withRelatedRenewFlag(relatedRenewFlagType));
    }

    public void purchaseReservedInstance(PurchaseReservedInstanceRequeset request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBillingWithReservation());
        }
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.purchaseReserved.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    @Deprecated
    public ListInstanceSpecsResponse listInstanceSpecs() {
        return this.listInstanceSpecs(new ListInstanceSpecsRequest());
    }

    @Deprecated
    public ListInstanceSpecsResponse listInstanceSpecs(ListInstanceSpecsRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, "spec");
        return this.invokeHttpClient(internalRequest, ListInstanceSpecsResponse.class);
    }

    public CreateVolumeResponse createVolume(CreateVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VOLUME_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateVolumeResponse.class);
    }

    public ListVolumesResponse listVolumes() {
        return this.listVolumes(new ListVolumesRequest());
    }

    public ListVolumesResponse listVolumes(ListVolumesRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VOLUME_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getInstanceId())) {
            internalRequest.addParameter(INSTANCEID_MESSAGE_KEY, request.getInstanceId());
        }
        if (!Strings.isNullOrEmpty((String)request.getZoneName())) {
            internalRequest.addParameter(ZONE_NAME, request.getZoneName());
        }
        return this.invokeHttpClient(internalRequest, ListVolumesResponse.class);
    }

    public GetVolumeResponse getVolume(String volumeId) {
        return this.getVolume(new GetVolumeRequest().withVolumeId(volumeId));
    }

    public GetVolumeResponse getVolume(GetVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VOLUME_PREFIX, request.getVolumeId());
        return this.invokeHttpClient(internalRequest, GetVolumeResponse.class);
    }

    public AttachVolumeResponse attachVolume(String volumeId, String instanceId) {
        return this.attachVolume(new AttachVolumeRequest().withVolumeId(volumeId).withInstanceId(instanceId));
    }

    public AttachVolumeResponse attachVolume(AttachVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.attach.name(), null);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AttachVolumeResponse.class);
    }

    public void detachVolume(String volumeId, String instanceId) {
        this.detachVolume(new DetachVolumeRequest().withVolumeId(volumeId).withInstanceId(instanceId));
    }

    public void detachVolume(DetachVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.detach.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseVolume(String volumeId) {
        this.releaseVolume(new ReleaseVolumeRequest().withVolumeId(volumeId));
    }

    public void releaseVolume(ReleaseVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        if (StringUtils.isEmpty((CharSequence)request.getAutoSnapshot()) && StringUtils.isEmpty((CharSequence)request.getManualSnapshot())) {
            InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VOLUME_PREFIX, request.getVolumeId());
            this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        } else {
            InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VOLUME_PREFIX, request.getVolumeId());
            this.fillPayload(internalRequest, request);
            this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
        }
    }

    public void modifyVolumeChargeType(ModifyVolumeChargeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        ModifyVolumeChargeRequest.ModifyVolumeChargeModel requestModel = request.toModifyVolumeChargeModel();
        InternalRequest internalRequest = this.createRequest(requestModel, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.modifyChargeType.name(), null);
        this.fillPayload(internalRequest, requestModel);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyVolumeChargeType(ModifyVolumeChargeTypeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.modifyChargeType.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void resizeVolume(String volumeId, int newCdsSizeInGB) {
        this.resizeVolume(new ResizeVolumeRequest().withVolumeId(volumeId).withNewCdsSizeInGB(newCdsSizeInGB));
    }

    public void resizeVolume(ResizeVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        Preconditions.checkState((request.getNewCdsSizeInGB() > 0 ? 1 : 0) != 0, (Object)"request newCdsSizeInGB should greater than 0");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.resize.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void rollbackVolume(String volumeId, String snapshotId) {
        this.rollbackVolume(new RollbackVolumeRequest().withVolumeId(volumeId).withSnapshotId(snapshotId));
    }

    public void rollbackVolume(RollbackVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSnapshotId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SNAPSHOTID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.rollback.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void purchaseReservedVolume(String volumeId, int reservationLength, String reservationTimeUnit) {
        this.purchaseReservedVolume(new PurchaseReservedVolumeRequest().withVolumeId(volumeId).withBilling(new Billing().withReservation(new Reservation().withReservationLength(reservationLength).withReservationTimeUnit(reservationTimeUnit))));
    }

    public void purchaseReservedVolume(PurchaseReservedVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBillingWithReservation());
        }
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.purchaseReserved.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void autoRenewVolume(String volumeId, String renewTimeUnit, int renewTime) {
        this.autoRenewVolume(new AutoRenewVolumeRequest().withVolumeId(volumeId).withRenewTimeUnit(renewTimeUnit).withRenewTime(renewTime));
    }

    public void autoRenewVolume(AutoRenewVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (request.getRenewTime() <= 0) {
            throw new IllegalArgumentException("request renewTime should be a positive integer");
        }
        if (!request.getRenewTimeUnit().equalsIgnoreCase("month") && !request.getRenewTimeUnit().equalsIgnoreCase("year")) {
            throw new IllegalArgumentException("request renewTimeUnit only support \"month\" and \"year\"");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VOLUME_PREFIX, VolumeAction.autoRenew.name());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void cancelAutoRenewVolume(CancelAutoRenewVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VOLUME_PREFIX, VolumeAction.cancelAutoRenew.name());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void renameVolume(RenameVolumeRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.rename.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyCdsAttribute(ModifyCdsAttrRequest modifyCdsAttrRequest) {
        Validate.checkNotNull(modifyCdsAttrRequest, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(modifyCdsAttrRequest.getCdsId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(modifyCdsAttrRequest, HttpMethodName.PUT, VOLUME_PREFIX, modifyCdsAttrRequest.getCdsId());
        internalRequest.addParameter(VolumeAction.modify.name(), null);
        this.fillPayload(internalRequest, modifyCdsAttrRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateImageResponse createImageFromInstance(String imageName, String instanceId) {
        return this.createImage(new CreateImageRequest().withImageName(imageName).withInstanceId(instanceId).withRelateCds(false));
    }

    public CreateImageResponse createImageFromInstanceWithRelateCds(String imageName, String instanceId, boolean relateCds) {
        return this.createImage(new CreateImageRequest().withImageName(imageName).withInstanceId(instanceId).withRelateCds(relateCds));
    }

    public CreateImageResponse createImageFromSnapshot(String imageName, String snapshotId) {
        return this.createImage(new CreateImageRequest().withImageName(imageName).withSnapshotId(snapshotId));
    }

    public CreateImageResponse createImage(CreateImageRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getImageName(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGENAME_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getInstanceId()) && Strings.isNullOrEmpty((String)request.getSnapshotId())) {
            throw new IllegalArgumentException("request instanceId or snapshotId should not be empty .");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IMAGE_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateImageResponse.class);
    }

    public ListImagesResponse listImages() {
        return this.listImages(new ListImagesRequest());
    }

    public ListImagesResponse listImages(ListImagesRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IMAGE_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getImageType())) {
            internalRequest.addParameter(IMAGE_TYPE, request.getImageType());
        }
        return this.invokeHttpClient(internalRequest, ListImagesResponse.class);
    }

    public GetImageResponse getImage(String imageId) {
        return this.getImage(new GetImageRequest().withImageId(imageId));
    }

    public GetImageResponse getImage(GetImageRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IMAGE_PREFIX, request.getImageId());
        return this.invokeHttpClient(internalRequest, GetImageResponse.class);
    }

    public void deleteImage(String imageId) {
        this.deleteImage(new DeleteImageRequest().withImageId(imageId));
    }

    public void deleteImage(DeleteImageRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, IMAGE_PREFIX, request.getImageId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void shareImage(ShareImageRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getAccount()) && Strings.isNullOrEmpty((String)request.getAccountId())) {
            throw new IllegalArgumentException("request account or accountId should not be empty .");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IMAGE_PREFIX, request.getImageId());
        internalRequest.addParameter(ImageAction.share.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unShareImage(UnShareImageRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getAccount()) && Strings.isNullOrEmpty((String)request.getAccountId())) {
            throw new IllegalArgumentException("request account or accountId should not be empty .");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IMAGE_PREFIX, request.getImageId());
        internalRequest.addParameter(ImageAction.unshare.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListSharedUserResponse listSharedUser(String imageId) {
        return this.listSharedUser(new ListSharedUserRequest().withImageId(imageId));
    }

    public ListSharedUserResponse listSharedUser(ListSharedUserRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IMAGE_PREFIX, request.getImageId(), SHARED_USER);
        return this.invokeHttpClient(internalRequest, ListSharedUserResponse.class);
    }

    public void remoteCopyImage(RemoteCopyImageRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGENAME_MESSAGE_KEY));
        if (request.getDestRegion() == null || request.getDestRegion().size() == 0) {
            throw new IllegalArgumentException("request destRegion should not be empty .");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IMAGE_PREFIX, request.getImageId());
        internalRequest.addParameter(ImageAction.remoteCopy.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void cancelRemoteCopyImage(String imageId) {
        this.cancelRemoteCopyImage(new CancelRemoteCopyImageRequest().withImageId(imageId));
    }

    public void cancelRemoteCopyImage(CancelRemoteCopyImageRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getImageId(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGEID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IMAGE_PREFIX, request.getImageId());
        internalRequest.addParameter(ImageAction.cancelRemoteCopy.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListOsResponse listOs(ListOsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (request.getInstanceIds().size() == 0) {
            throw new IllegalArgumentException("request instanceIds should not be empty.");
        }
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IMAGE_PREFIX, OS_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ListOsResponse.class);
    }

    public CreateSnapshotResponse createSnapshot(String volumeId, String snapshotName) {
        return this.createSnapshot(new CreateSnapshotRequest().withVolumeId(volumeId).withSnapshotName(snapshotName));
    }

    public CreateSnapshotResponse createSnapshot(String volumeId, String snapshotName, String desc) {
        return this.createSnapshot(new CreateSnapshotRequest().withVolumeId(volumeId).withSnapshotName(snapshotName).withDesc(desc));
    }

    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getVolumeId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getSnapshotName(), StringFormatUtils.checkEmptyExceptionMessageFormat(SNAPSHOTNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SNAPSHOT_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateSnapshotResponse.class);
    }

    public ListSnapshotsResponse listSnapshots(ListSnapshotsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SNAPSHOT_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getVolumeId())) {
            internalRequest.addParameter(VOLUMEID_MESSAGE_KEY, request.getVolumeId());
        }
        return this.invokeHttpClient(internalRequest, ListSnapshotsResponse.class);
    }

    public GetSnapshotResponse getSnapshot(String snapshotId) {
        return this.getSnapshot(new GetSnapshotRequest().withSnapshotId(snapshotId));
    }

    public GetSnapshotResponse getSnapshot(GetSnapshotRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSnapshotId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SNAPSHOTID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SNAPSHOT_PREFIX, request.getSnapshotId());
        return this.invokeHttpClient(internalRequest, GetSnapshotResponse.class);
    }

    public void deleteSnapshot(String snapshotId) {
        this.deleteSnapshot(new DeleteSnapshotRequest().withSnapshotId(snapshotId));
    }

    public void deleteSnapshot(DeleteSnapshotRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSnapshotId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SNAPSHOTID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, SNAPSHOT_PREFIX, request.getSnapshotId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListSnapchainResponse listSnapchain(ListSnapchainRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SNAPSHOT_PREFIX, CHAIN);
        return this.invokeHttpClient(internalRequest, ListSnapchainResponse.class);
    }

    public CreateAspResponse createAsp(CreateAspRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(ASPNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ASP);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateAspResponse.class);
    }

    public void deleteAsp(DeleteAspRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getAspId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ASPID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ASP, request.getAspId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteAsp(String aspId) {
        this.deleteAsp(new DeleteAspRequest().withAspId(aspId));
    }

    public void attachAsp(AttachAspRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getAspId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ASPID_MESSAGE_KEY));
        for (String volumeId : request.getVolumeIds()) {
            Validate.checkStringNotEmpty(volumeId, StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ASP, request.getAspId());
        internalRequest.addParameter(AspAction.attach.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void detachAsp(DetachAspRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getAspId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ASPID_MESSAGE_KEY));
        for (String volumeId : request.getVolumeIds()) {
            Validate.checkStringNotEmpty(volumeId, StringFormatUtils.checkEmptyExceptionMessageFormat(VOLUMEID_MESSAGE_KEY));
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ASP, request.getAspId());
        internalRequest.addParameter(AspAction.detach.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListAspsResponse listAsps(ListAspsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ASP);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getAspName())) {
            internalRequest.addParameter(ASPNAME_MESSAGE_KEY, request.getAspName());
        }
        if (!Strings.isNullOrEmpty((String)request.getVolumeName())) {
            internalRequest.addParameter(VOLUME_NAME, request.getVolumeName());
        }
        return this.invokeHttpClient(internalRequest, ListAspsResponse.class);
    }

    public GetAspResponse getAsp(GetAspRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getAspId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ASPID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ASP, request.getAspId());
        return this.invokeHttpClient(internalRequest, GetAspResponse.class);
    }

    public GetAspResponse getAsp(String aspId) {
        return this.getAsp(new GetAspRequest().withAspId(aspId));
    }

    public void updateAsp(UpdateAspRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(ASPNAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAspId(), StringFormatUtils.checkEmptyExceptionMessageFormat(ASPNAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ASP, AspAction.update.name());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListSecurityGroupsResponse listSecurityGroups(ListSecurityGroupsRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SECURITYGROUP_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getInstanceId())) {
            internalRequest.addParameter(INSTANCEID_MESSAGE_KEY, request.getInstanceId());
        }
        if (!Strings.isNullOrEmpty((String)request.getVpcId())) {
            internalRequest.addParameter(VPC_ID, request.getVpcId());
        }
        return this.invokeHttpClient(internalRequest, ListSecurityGroupsResponse.class);
    }

    public CreateSecurityGroupResponse createSecurityGroup(CreateSecurityGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        if (null == request.getRules() || request.getRules().isEmpty()) {
            throw new IllegalArgumentException("request rules should not be empty");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SECURITYGROUP_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateSecurityGroupResponse.class);
    }

    public void authorizeSecurityGroupRule(SecurityGroupRuleOperateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITYGROUPID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getRule()) {
            throw new IllegalArgumentException("request rule should not be null");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SECURITYGROUP_PREFIX, request.getSecurityGroupId());
        internalRequest.addParameter(SecurityGroupAction.authorizeRule.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void revokeSecurityGroupRule(SecurityGroupRuleOperateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITYGROUPID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getRule()) {
            throw new IllegalArgumentException("request rule should not be null");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SECURITYGROUP_PREFIX, request.getSecurityGroupId());
        internalRequest.addParameter(SecurityGroupAction.revokeRule.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteSecurityGroup(String securityGroupId) {
        this.deleteSecurityGroup(new DeleteSecurityGroupRequest().withSecurityGroupId(securityGroupId));
    }

    public void deleteSecurityGroup(DeleteSecurityGroupRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), StringFormatUtils.checkEmptyExceptionMessageFormat(SECURITYGROUPID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, SECURITYGROUP_PREFIX, request.getSecurityGroupId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListZonesResponse listZones() {
        return this.listZones(new AbstractBceRequest(){

            @Override
            public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
                return null;
            }
        });
    }

    public ListZonesResponse listZones(AbstractBceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ZONE);
        return this.invokeHttpClient(internalRequest, ListZonesResponse.class);
    }

    public KeypairModel createKeypair(KeypairCreateRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "keypair");
        internalRequest.addParameter(KeypairAction.create.name(), null);
        this.fillPayload(internalRequest, request);
        KeypairCreateResponse response = this.invokeHttpClient(internalRequest, KeypairCreateResponse.class);
        return response.getKeypair();
    }

    public KeypairModel importKeypair(KeypairImportRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "keypair");
        this.fillPayload(internalRequest, request);
        KeypairCreateResponse response = this.invokeHttpClient(internalRequest, KeypairCreateResponse.class);
        return response.getKeypair();
    }

    public void attachKeypair(KeypairAttachRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getKeypairId(), StringFormatUtils.checkEmptyExceptionMessageFormat("keypair"));
        if (request.getInstanceIds() == null || request.getInstanceIds().size() == 0) {
            throw new IllegalArgumentException("keypair attach: instanceIds can not be empty");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "keypair", request.getKeypairId());
        internalRequest.addParameter(KeypairAction.attach.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void detachKeypair(KeypairDetachRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getKeypairId(), StringFormatUtils.checkEmptyExceptionMessageFormat("keypair"));
        if (request.getInstanceIds() == null || request.getInstanceIds().size() == 0) {
            throw new IllegalArgumentException("keypair detach: instanceIds can not be empty");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "keypair", request.getKeypairId());
        internalRequest.addParameter(KeypairAction.detach.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteKeypair(KeypairDeleteRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getKeypairId(), StringFormatUtils.checkEmptyExceptionMessageFormat("keypair"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, "keypair", request.getKeypairId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public KeypairModel keypairDetail(KeypairDetailRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getKeypairId(), StringFormatUtils.checkEmptyExceptionMessageFormat("keypair"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "keypair", request.getKeypairId());
        KeypairResponse response = this.invokeHttpClient(internalRequest, KeypairResponse.class);
        return response.getKeypair();
    }

    public KeypairListResponse listKeypair(KeypairListRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "keypair");
        if (request.getMarker() != null) {
            internalRequest.addParameter(MARKER, request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter(MAX_KEYS, String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, KeypairListResponse.class);
    }

    public void renameKeypair(KeypairRenameRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getKeypairId(), StringFormatUtils.checkEmptyExceptionMessageFormat("keypair"));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "keypair", request.getKeypairId());
        internalRequest.addParameter(KeypairAction.rename.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateKeypairDescription(KeypairUpdateDescRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getKeypairId(), StringFormatUtils.checkEmptyExceptionMessageFormat("keypair"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "keypair", request.getKeypairId());
        internalRequest.addParameter(KeypairAction.updateDesc.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListDeploySetResponse listDeploySet() {
        return this.listDeploySet(new AbstractBceRequest(){

            @Override
            public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
                return null;
            }
        });
    }

    private ListDeploySetResponse listDeploySet(AbstractBceRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, DEPLOYSET, DeploySetAction.list.name());
        return this.invokeHttpClient(internalRequest, ListDeploySetResponse.class);
    }

    public CreateDeploySetResponse createDeploySet(CreateDeploySetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX, DEPLOYSET, DeploySetAction.create.name());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateDeploySetResponse.class);
    }

    public void deleteDeploySet(DeleteDeploySetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, INSTANCE_PREFIX, DEPLOYSET, request.getDeployId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateDeploySet(UpdateDeploySetRequest request) {
        Validate.checkNotNull(request, REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, DEPLOYSET, request.getDeployId());
        internalRequest.addParameter(DeploySetAction.modifyAttribute.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

