/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bcc.model.volume;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bcc.model.Billing;
import com.baidubce.services.bcc.model.Reservation;

public class ModifyVolumeChargeRequest
extends AbstractBceRequest {
    private String volumeId;
    private String billingMethod;
    private int reservationLength;

    public ModifyVolumeChargeRequest withVolumeId(String volumeId) {
        this.volumeId = volumeId;
        return this;
    }

    public ModifyVolumeChargeRequest withBillingMethod(String billingMethod) {
        if (!"prepay".equals(billingMethod) && !"postpay".equals(billingMethod)) {
            throw new IllegalArgumentException("billingMethod can only be set to 'prepay' or 'postpay'");
        }
        this.billingMethod = billingMethod;
        return this;
    }

    public ModifyVolumeChargeRequest withReservationLength(int reservationLength) {
        if (reservationLength < 0) {
            throw new IllegalArgumentException("reservationLength can not be negative integer");
        }
        this.reservationLength = reservationLength;
        return this;
    }

    public String getBillingMethod() {
        return this.billingMethod;
    }

    public void setBillingMethod(String billingMethod) {
        if (!"prepay".equals(billingMethod) && !"postpay".equals(billingMethod)) {
            throw new IllegalArgumentException("billingMethod can only be set to 'prepay' or 'postpay'");
        }
        this.billingMethod = billingMethod;
    }

    public int getReservationLength() {
        return this.reservationLength;
    }

    public void setReservationLength(int reservationLength) {
        if (reservationLength < 0) {
            throw new IllegalArgumentException("reservationLength can not be negative integer");
        }
        this.reservationLength = reservationLength;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public ModifyVolumeChargeModel toModifyVolumeChargeModel() {
        ModifyVolumeChargeModel modifyVolumeChargeModel = new ModifyVolumeChargeModel();
        Reservation reservation = new Reservation();
        Billing billing = new Billing();
        if ("prepay".equals(this.billingMethod)) {
            reservation.withReservationLength(this.reservationLength);
            billing.withReservation(reservation);
        } else if ("postpay".equals(this.billingMethod)) {
            reservation.withReservationLength(0);
            billing.withReservation(reservation);
        } else {
            throw new IllegalArgumentException("billingMethod can only be set to 'prepay' or 'postpay'");
        }
        modifyVolumeChargeModel.setBilling(billing);
        return modifyVolumeChargeModel;
    }

    public static class ModifyVolumeChargeModel
    extends AbstractBceRequest {
        private Billing billing;

        public Billing getBilling() {
            return this.billing;
        }

        public void setBilling(Billing billing) {
            this.billing = billing;
        }

        @Override
        public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
            this.setRequestCredentials(credentials);
            return this;
        }
    }
}

