/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.demo;

import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.InputSerialization;
import com.baidubce.services.bos.model.OutputSerialization;
import com.baidubce.services.bos.model.SelectObjectRequest;
import com.baidubce.services.bos.model.SelectObjectResponse;
import java.io.ByteArrayInputStream;

public class SelectContentDemo {
    public static void selectCsv() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        String csvContent = "header1,header2,header3\r\n1,2,3.4\r\na,b,c\r\n\"d\",\"e\",\"f\"\r\ntrue,false,true\r\n2006-01-02 15:04:06,2006-01-02 16:04:06,2006-01-02 17:04:06";
        client.putObject("bucketName", "test-csv", new ByteArrayInputStream("header1,header2,header3\r\n1,2,3.4\r\na,b,c\r\n\"d\",\"e\",\"f\"\r\ntrue,false,true\r\n2006-01-02 15:04:06,2006-01-02 16:04:06,2006-01-02 17:04:06".getBytes()));
        SelectObjectRequest request = new SelectObjectRequest("bucketName", "test-csv").withSelectType("csv").withExpression("select * from BosObject limit 3").withInputSerialization(new InputSerialization().withCompressionType("NONE").withFileHeaderInfo("NONE").withRecordDelimiter("\r\n").withFieldDelimiter(",").withQuoteCharacter("\"").withCommentCharacter("#")).withOutputSerialization(new OutputSerialization().withOutputHeader(false).withQuoteFields("ALWAYS").withRecordDelimiter("\n").withFieldDelimiter(",").withQuoteCharacter("\"")).withRequestProgress(false);
        SelectObjectResponse response = client.selectObject(request);
        SelectObjectResponse.Messages messages = response.getMessages();
        while (messages.hasNext()) {
            SelectObjectResponse.CommonMessage message = messages.next();
            if (!message.Type.equals("Records")) continue;
            for (String record : message.getRecords()) {
                System.out.println(record);
            }
        }
        client.shutdown();
    }

    public static void selectJson() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        String jsonContent = "{\n\t\"name\": \"Smith\",\n\t\"age\": 16,\n\t\"org\": null\n}\n{\n\t\"name\": \"charles\",\n\t\"age\": 27,\n\t\"org\": \"baidu\"\n}\n{\n\t\"name\": \"jack\",\n\t\"age\": 35,\n\t\"org\": \"bos\"\n}";
        client.putObject("bucketName", "test-json", new ByteArrayInputStream("{\n\t\"name\": \"Smith\",\n\t\"age\": 16,\n\t\"org\": null\n}\n{\n\t\"name\": \"charles\",\n\t\"age\": 27,\n\t\"org\": \"baidu\"\n}\n{\n\t\"name\": \"jack\",\n\t\"age\": 35,\n\t\"org\": \"bos\"\n}".getBytes()));
        SelectObjectRequest request = new SelectObjectRequest("bucketName", "test-json").withSelectType("json").withExpression("select * from BosObject where age > 20").withInputSerialization(new InputSerialization().withCompressionType("NONE").withJsonType("LINES")).withOutputSerialization(new OutputSerialization().withRecordDelimiter("\n")).withRequestProgress(false);
        SelectObjectResponse response = client.selectObject(request);
        SelectObjectResponse.Messages messages = response.getMessages();
        while (messages.hasNext()) {
            SelectObjectResponse.CommonMessage message = messages.next();
            if (!message.Type.equals("Records")) continue;
            for (String record : message.getRecords()) {
                System.out.println(record);
            }
        }
        client.shutdown();
    }
}

