/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cfc.model;

import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonProperty;

public abstract class GenericAliasRequest
extends AbstractBceRequest {
    private static final int MIN_ALIAS_LENGTH = 1;
    private static final int MAX_ALIAS_LENGTH = 64;
    @JsonProperty(value="Name")
    private String Name;

    public GenericAliasRequest() {
    }

    public GenericAliasRequest(String name) {
        this.setName(name);
    }

    @JsonProperty(value="Name")
    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        if (name == null) {
            this.Name = name;
            return;
        }
        if ((name = name.trim()).length() < 1) {
            throw new IllegalArgumentException("Invalid name: " + name + ". name should not be less than " + 1 + ".");
        }
        if (name.length() > 64) {
            throw new IllegalArgumentException("Invalid name: " + name + ". name should not be greater than " + 64 + ".");
        }
        if (!GenericAliasRequest.isLegalAlias(name)) {
            throw new IllegalArgumentException("Invalid name: " + name + ". name should be letters or digit or - or _ or / or . and the first character should be letter.");
        }
        this.Name = name;
    }

    private static boolean isLegalAlias(String alias) {
        String regex = "^[a-z0-9A-Z-_/.]+$";
        return alias.matches(regex) && GenericAliasRequest.isLetter(alias.charAt(0));
    }

    private static boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    public abstract GenericAliasRequest withName(String var1);
}

