/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.dcc;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.bcc.model.Billing;
import com.baidubce.services.bcc.model.Reservation;
import com.baidubce.services.dcc.DccClientConfiguration;
import com.baidubce.services.dcc.model.CreateDccInstanceRequest;
import com.baidubce.services.dcc.model.CreateDccInstanceResponse;
import com.baidubce.services.dcc.model.CreateDccRequest;
import com.baidubce.services.dcc.model.CreateDccResponse;
import com.baidubce.services.dcc.model.DccAction;
import com.baidubce.services.dcc.model.DccBindTagsRequest;
import com.baidubce.services.dcc.model.DccDetailRequest;
import com.baidubce.services.dcc.model.DccDetailResponse;
import com.baidubce.services.dcc.model.DccModel;
import com.baidubce.services.dcc.model.DccRenameRequest;
import com.baidubce.services.dcc.model.DccUnbindTagsRequest;
import com.baidubce.services.dcc.model.ListDccRequest;
import com.baidubce.services.dcc.model.ListDccResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DccClient.class);
    private static final String VERSION = "v1";
    private static final String DCC_PREFIX = "dedicatedHost";
    private static final String INSTANCE_PREFIX = "instance";
    private static final String TAG = "tag";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String FLAVOR_NULL_MESSAGE_KEY = "flavor";
    private static final String DCC_ID_MESSAGE_KEY = "dcc id";
    private static final String INSTANCEID_MESSAGE_KEY = "instanceId";
    private static final String NAME_MESSAGE_KEY = "name";
    private static final HttpResponseHandler[] dcc_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public DccClient() {
        this(new DccClientConfiguration());
    }

    public DccClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, dcc_handlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    private String aes128WithFirst16Char(String content, String privateKey) throws GeneralSecurityException {
        byte[] crypted = null;
        SecretKeySpec skey = new SecretKeySpec(privateKey.substring(0, 16).getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        crypted = cipher.doFinal(content.getBytes());
        return new String(Hex.encodeHex((byte[])crypted));
    }

    private Billing generateDefaultBilling() {
        Billing billing = new Billing();
        billing.setPaymentTiming("Postpaid");
        Reservation reservation = new Reservation();
        reservation.setReservationLength(1);
        billing.setReservation(reservation);
        return billing;
    }

    private Billing generateDefaultBillingWithReservation() {
        Billing billing = new Billing();
        billing.withReservation(new Reservation().withReservationLength(1));
        return billing;
    }

    public CreateDccResponse createDcc(CreateDccRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        request.checkAutoRenewTime();
        request.checkCloudDiskType();
        Validate.checkStringNotEmpty(request.getFlavor(), StringFormatUtils.checkEmptyExceptionMessageFormat(FLAVOR_NULL_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DCC_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateDccResponse.class);
    }

    public CreateDccInstanceResponse createDccInstance(CreateDccInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DCC_PREFIX, INSTANCE_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateDccInstanceResponse.class);
    }

    public CreateDccInstanceResponse createDccInstanceWithEncryption(CreateDccInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DCC_PREFIX, INSTANCE_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getAdminPass())) {
            BceCredentials credentials = this.config.getCredentials();
            if (internalRequest.getCredentials() != null) {
                credentials = internalRequest.getCredentials();
            }
            try {
                request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
            }
            catch (GeneralSecurityException e) {
                throw new BceClientException("Encryption procedure exception", e);
            }
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateDccInstanceResponse.class);
    }

    public void dccBindTags(DccBindTagsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getDccId(), StringFormatUtils.checkEmptyExceptionMessageFormat(DCC_ID_MESSAGE_KEY));
        if (request.getChangeTags() == null || request.getChangeTags().size() == 0) {
            throw new IllegalArgumentException("dcc bind tags: tags is empty");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DCC_PREFIX, request.getDccId(), TAG);
        internalRequest.addParameter(DccAction.bind.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void dccUnbindTags(DccUnbindTagsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getDccId(), StringFormatUtils.checkEmptyExceptionMessageFormat(DCC_ID_MESSAGE_KEY));
        if (request.getChangeTags() == null || request.getChangeTags().size() == 0) {
            throw new IllegalArgumentException("dcc unbind tags: tags is empty");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DCC_PREFIX, request.getDccId(), TAG);
        internalRequest.addParameter(DccAction.unbind.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void dccRename(DccRenameRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getInstanceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(INSTANCEID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DCC_PREFIX, request.getInstanceId());
        internalRequest.addParameter(DccAction.modifyAttribute.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DccModel dccDetail(DccDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getDccId(), StringFormatUtils.checkEmptyExceptionMessageFormat(DCC_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DCC_PREFIX, request.getDccId());
        DccDetailResponse response = this.invokeHttpClient(internalRequest, DccDetailResponse.class);
        return response.getDedicatedHost();
    }

    public ListDccResponse dccList(ListDccRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DCC_PREFIX);
        return this.invokeHttpClient(internalRequest, ListDccResponse.class);
    }
}

