/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iam;

import com.baidubce.BceClientConfiguration;
import com.baidubce.common.ApiInfo;
import com.baidubce.common.BaseBceClient;
import com.baidubce.common.BaseBceResponse;
import com.baidubce.common.BceRegion;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.iam.api.IamApi;
import com.baidubce.services.iam.model.CreateAccessKeyResponse;
import com.baidubce.services.iam.model.CreateGroupRequest;
import com.baidubce.services.iam.model.CreateGroupResponse;
import com.baidubce.services.iam.model.CreatePolicyRequest;
import com.baidubce.services.iam.model.CreatePolicyResponse;
import com.baidubce.services.iam.model.CreateRoleRequest;
import com.baidubce.services.iam.model.CreateRoleResponse;
import com.baidubce.services.iam.model.CreateUserRequest;
import com.baidubce.services.iam.model.CreateUserResponse;
import com.baidubce.services.iam.model.DisableAccessKeyResponse;
import com.baidubce.services.iam.model.EnableAccessKeyResponse;
import com.baidubce.services.iam.model.GetGroupResponse;
import com.baidubce.services.iam.model.GetLoginProfileResponse;
import com.baidubce.services.iam.model.GetPolicyResponse;
import com.baidubce.services.iam.model.GetRoleResponse;
import com.baidubce.services.iam.model.GetUserResponse;
import com.baidubce.services.iam.model.ListAccessKeyResponse;
import com.baidubce.services.iam.model.ListGroupResponse;
import com.baidubce.services.iam.model.ListGroupsForUserResponse;
import com.baidubce.services.iam.model.ListPoliciesForGroupResponse;
import com.baidubce.services.iam.model.ListPoliciesForRoleResponse;
import com.baidubce.services.iam.model.ListPoliciesForUserResponse;
import com.baidubce.services.iam.model.ListPolicyResponse;
import com.baidubce.services.iam.model.ListRoleResponse;
import com.baidubce.services.iam.model.ListUserResponse;
import com.baidubce.services.iam.model.ListUsersInGroupResponse;
import com.baidubce.services.iam.model.UpdateGroupRequest;
import com.baidubce.services.iam.model.UpdateGroupResponse;
import com.baidubce.services.iam.model.UpdateLoginProfileRequest;
import com.baidubce.services.iam.model.UpdateLoginProfileResponse;
import com.baidubce.services.iam.model.UpdateRoleRequest;
import com.baidubce.services.iam.model.UpdateRoleResponse;
import com.baidubce.services.iam.model.UpdateUserRequest;
import com.baidubce.services.iam.model.UpdateUserResponse;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class IamClient
extends BaseBceClient {
    private static final Map<BceRegion, String> ENDPOINTS = ImmutableMap.builder().put((Object)BceRegion.DEFAULT, (Object)"https://iam.bj.baidubce.com").build();
    private static final String SERVICE_ID = "Iam";
    private static final Map<String, ApiInfo> IAM_APIS = IamApi.getApis();

    public IamClient(String ak, String sk, BceRegion region) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)region));
    }

    public IamClient(String ak, String sk) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)BceRegion.DEFAULT));
    }

    public IamClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public void addUserToGroup(String userName, String groupName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("addUserToGroup"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).withPathParameter("groupName", groupName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void attachPolicyToGroup(String groupName, String policyName, String policyType) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("attachPolicyToGroup"));
        String apiPath = apiInfo.getPath().withPathParameter("groupName", groupName).withPathParameter("policyName", policyName).get();
        apiInfo.getQueries().put("policyType", policyType);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void attachPolicyToRole(String roleName, String policyName, String policyType) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("attachPolicyToRole"));
        String apiPath = apiInfo.getPath().withPathParameter("roleName", roleName).withPathParameter("policyName", policyName).get();
        apiInfo.getQueries().put("policyType", policyType);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void attachPolicyToUser(String userName, String policyName, String policyType) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("attachPolicyToUser"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).withPathParameter("policyName", policyName).get();
        apiInfo.getQueries().put("policyType", policyType);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public CreateAccessKeyResponse createAccessKey(String userName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("createAccessKey"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, CreateAccessKeyResponse.class);
    }

    public CreateGroupResponse createGroup(CreateGroupRequest body) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("createGroup"));
        String apiPath = apiInfo.getPath().get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreateGroupResponse.class);
    }

    public CreatePolicyResponse createPolicy(CreatePolicyRequest body) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("createPolicy"));
        String apiPath = apiInfo.getPath().get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreatePolicyResponse.class);
    }

    public CreateRoleResponse createRole(CreateRoleRequest body) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("createRole"));
        String apiPath = apiInfo.getPath().get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreateRoleResponse.class);
    }

    public CreateUserResponse createUser(CreateUserRequest body) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("createUser"));
        String apiPath = apiInfo.getPath().get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreateUserResponse.class);
    }

    public void deleteAccessKey(String userName, String accessKeyId) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("deleteAccessKey"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).withPathParameter("accessKeyId", accessKeyId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteGroup(String groupName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("deleteGroup"));
        String apiPath = apiInfo.getPath().withPathParameter("groupName", groupName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteLoginProfile(String userName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("deleteLoginProfile"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deletePolicy(String policyName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("deletePolicy"));
        String apiPath = apiInfo.getPath().withPathParameter("policyName", policyName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteRole(String roleName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("deleteRole"));
        String apiPath = apiInfo.getPath().withPathParameter("roleName", roleName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteUser(String userName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("deleteUser"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void detachPolicyFromGroup(String groupName, String policyName, String policyType) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("detachPolicyFromGroup"));
        String apiPath = apiInfo.getPath().withPathParameter("groupName", groupName).withPathParameter("policyName", policyName).get();
        apiInfo.getQueries().put("policyType", policyType);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void detachPolicyFromRole(String roleName, String policyName, String policyType) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("detachPolicyFromRole"));
        String apiPath = apiInfo.getPath().withPathParameter("roleName", roleName).withPathParameter("policyName", policyName).get();
        apiInfo.getQueries().put("policyType", policyType);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void detachPolicyFromUser(String userName, String policyName, String policyType) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("detachPolicyFromUser"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).withPathParameter("policyName", policyName).get();
        apiInfo.getQueries().put("policyType", policyType);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public DisableAccessKeyResponse disableAccessKey(String userName, String accessKeyId) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("disableAccessKey"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).withPathParameter("accessKeyId", accessKeyId).get();
        apiInfo.getQueries().put("disable", null);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, DisableAccessKeyResponse.class);
    }

    public EnableAccessKeyResponse enableAccessKey(String userName, String accessKeyId) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("updateAccessKeyEnable"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).withPathParameter("accessKeyId", accessKeyId).get();
        apiInfo.getQueries().put("enable", null);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, EnableAccessKeyResponse.class);
    }

    public GetGroupResponse getGroup(String groupName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("getGroup"));
        String apiPath = apiInfo.getPath().withPathParameter("groupName", groupName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetGroupResponse.class);
    }

    public GetLoginProfileResponse getLoginProfile(String userName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("getLoginProfile"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetLoginProfileResponse.class);
    }

    public GetPolicyResponse getPolicy(String policyName, String policyType) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("getPolicy"));
        String apiPath = apiInfo.getPath().withPathParameter("policyName", policyName).get();
        apiInfo.getQueries().put("policyType", policyType);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetPolicyResponse.class);
    }

    public GetRoleResponse getRole(String roleName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("getRole"));
        String apiPath = apiInfo.getPath().withPathParameter("roleName", roleName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetRoleResponse.class);
    }

    public GetUserResponse getUser(String userName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("getUser"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetUserResponse.class);
    }

    public ListAccessKeyResponse listAccessKey(String userName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listAccessKey"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListAccessKeyResponse.class);
    }

    public ListGroupResponse listGroup() {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listGroup"));
        String apiPath = apiInfo.getPath().get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListGroupResponse.class);
    }

    public ListGroupsForUserResponse listGroupsForUser(String userName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listGroupsForUser"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListGroupsForUserResponse.class);
    }

    public ListPoliciesForGroupResponse listPoliciesForGroup(String groupName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listPoliciesForGroup"));
        String apiPath = apiInfo.getPath().withPathParameter("groupName", groupName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListPoliciesForGroupResponse.class);
    }

    public ListPoliciesForRoleResponse listPoliciesForRole(String roleName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listPoliciesForRole"));
        String apiPath = apiInfo.getPath().withPathParameter("roleName", roleName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListPoliciesForRoleResponse.class);
    }

    public ListPoliciesForUserResponse listPoliciesForUser(String userName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listPoliciesForUser"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListPoliciesForUserResponse.class);
    }

    public ListPolicyResponse listPolicy(String policyType) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listPolicy"));
        String apiPath = apiInfo.getPath().get();
        apiInfo.getQueries().put("policyType", policyType);
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListPolicyResponse.class);
    }

    public ListRoleResponse listRole() {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listRole"));
        String apiPath = apiInfo.getPath().get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListRoleResponse.class);
    }

    public ListUserResponse listUser() {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listUser"));
        String apiPath = apiInfo.getPath().get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListUserResponse.class);
    }

    public ListUsersInGroupResponse listUsersInGroup(String groupName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("listUsersInGroup"));
        String apiPath = apiInfo.getPath().withPathParameter("groupName", groupName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListUsersInGroupResponse.class);
    }

    public void removeUserFromGroup(String userName, String groupName) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("removeUserFromGroup"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).withPathParameter("groupName", groupName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public UpdateGroupResponse updateGroup(String groupName, UpdateGroupRequest body) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("updateGroup"));
        String apiPath = apiInfo.getPath().withPathParameter("groupName", groupName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, UpdateGroupResponse.class);
    }

    public UpdateLoginProfileResponse updateLoginProfile(String userName, UpdateLoginProfileRequest body) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("updateLoginProfile"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, UpdateLoginProfileResponse.class);
    }

    public UpdateRoleResponse updateRole(String roleName, UpdateRoleRequest body) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("updateRole"));
        String apiPath = apiInfo.getPath().withPathParameter("roleName", roleName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, UpdateRoleResponse.class);
    }

    public UpdateUserResponse updateUser(String userName, UpdateUserRequest body) {
        ApiInfo apiInfo = new ApiInfo(IAM_APIS.get("updateUser"));
        String apiPath = apiInfo.getPath().withPathParameter("userName", userName).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, UpdateUserResponse.class);
    }
}

