/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk.device.crypto;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class HashCrypto {
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final int PBKDF2_DERIVED_KEY_LENGTH_IN_BIT = 128;

    public static byte[] hmacSha256(byte[] data, byte[] keyBytes) throws Exception {
        Mac mac = Mac.getInstance(HMAC_SHA256);
        SecretKeySpec key = new SecretKeySpec(keyBytes, HMAC_SHA256);
        mac.init(key);
        mac.reset();
        mac.update(data, 0, data.length);
        return mac.doFinal();
    }

    public static byte[] pbkdf2WithHmacSha256(byte[] password, byte[] salt, int iteration) {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        generator.init(password, salt, iteration);
        return ((KeyParameter)generator.generateDerivedParameters(128)).getKey();
    }
}

