/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ocr.model;

import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.ocr.model.FormAbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class GeneralRecognitionRequest
extends FormAbstractBceRequest {
    private String image;
    @JsonProperty(value="recognize_granularity")
    private String granularity = "big";
    private String mask = "";
    @JsonProperty(value="language_type")
    private String langType = "CHN_ENG";
    @JsonProperty(value="detect_direction")
    private Boolean direction = false;

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public GeneralRecognitionRequest withImage(String image) {
        this.image = image;
        return this;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public GeneralRecognitionRequest withGranularity(String granularity) {
        this.granularity = granularity;
        return this;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public GeneralRecognitionRequest withMask(String mask) {
        this.mask = mask;
        return this;
    }

    public String getLangType() {
        return this.langType;
    }

    public void setLangType(String langType) {
        this.langType = langType;
    }

    public GeneralRecognitionRequest withLangType(String langType) {
        this.langType = langType;
        return this;
    }

    public Boolean getDirection() {
        return this.direction;
    }

    public void setDirection(Boolean direction) {
        this.direction = direction;
    }

    public GeneralRecognitionRequest withDirection(Boolean direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public String toFormString() {
        try {
            return "image=" + URLEncoder.encode(this.image, "UTF-8") + "&recognize_granularity=" + this.granularity + "&mask=" + this.mask + "&language_type=" + this.langType + "&detect_direction=" + this.direction;
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public String toString() {
        return "GeneralRecognitionRequest{image='" + this.image + '\'' + ", granularity='" + this.granularity + '\'' + ", mask='" + this.mask + '\'' + ", langType='" + this.langType + '\'' + ", direction=" + this.direction + "" + '}';
    }
}

