/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ros;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.ros.BaseRosClient;
import com.baidubce.services.ros.model.BaseResponse;
import com.baidubce.services.ros.model.CurrentTaskResponse;
import com.baidubce.services.ros.model.DeleteMatrixResponse;
import com.baidubce.services.ros.model.FastOrderProblem;
import com.baidubce.services.ros.model.FastOrderSolutionResponse;
import com.baidubce.services.ros.model.FastOrderSolutionResponseV2;
import com.baidubce.services.ros.model.GetSchedulerResultResponse;
import com.baidubce.services.ros.model.GetSingleVehicleResultResponse;
import com.baidubce.services.ros.model.HighWayLocationResponse;
import com.baidubce.services.ros.model.MatrixResponse;
import com.baidubce.services.ros.model.OptimizationProblemRequest;
import com.baidubce.services.ros.model.OrderedProblemRequest;
import com.baidubce.services.ros.model.ProblemRequest;
import com.baidubce.services.ros.model.RosGeneralResponse;
import com.baidubce.services.ros.model.UpdateWeightResponse;
import com.baidubce.services.ros.model.matrix.MatrixCreateRequest;
import com.baidubce.services.ros.model.matrix.MatrixDeleteRequest;
import com.baidubce.services.ros.model.matrix.MatrixMixedUpdateRequest;
import com.baidubce.services.ros.model.matrix.MatrixPointRequest;
import com.baidubce.services.ros.model.matrix.MatrixUpdateRequest;
import com.baidubce.services.ros.model.matrix.WeightUpdateRequest;
import com.baidubce.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosClient
extends BaseRosClient {
    private static final Logger log = LoggerFactory.getLogger(RosClient.class);
    private static final String FAST_ORDER_PATH = "/v1/scheduler/fastorder";
    private static final String FAST_ORDER_PATH_V2 = "/v2/scheduler/fastorder";
    private static final String PROBLEM_PATH = "/v1/scheduler/problem";
    private static final String MATRIX_PATH = "/v1/matrix";

    public RosClient() {
    }

    public RosClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public RosClient(String accessKey, String secretKey) {
        super(accessKey, secretKey);
    }

    public RosGeneralResponse createFastOrderTask(FastOrderProblem problem) {
        InternalRequest internalRequest = this.createRequest(problem, HttpMethodName.POST, FAST_ORDER_PATH);
        log.info("FastOrderProblem is :{}", (Object)JsonUtils.toJsonString(internalRequest));
        return this.invokeHttpClient(internalRequest, RosGeneralResponse.class);
    }

    public FastOrderSolutionResponse getFastOrderSolutionResponse(String problemId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v1/scheduler/fastorder/" + problemId);
        log.info("FastOrderProblem query request is :{}", (Object)JsonUtils.toJsonString(internalRequest));
        return this.invokeHttpClient(internalRequest, FastOrderSolutionResponse.class);
    }

    public FastOrderSolutionResponseV2 getFastOrderSolutionResponseV2(String problemId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v2/scheduler/fastorder/" + problemId);
        log.info("FastOrderProblem query request is :{}", (Object)JsonUtils.toJsonString(internalRequest));
        return this.invokeHttpClient(internalRequest, FastOrderSolutionResponseV2.class);
    }

    public BaseResponse createProblem(ProblemRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PROBLEM_PATH);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public GetSchedulerResultResponse getSchedulerTaskResult(String problemId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v1/scheduler/problem/" + problemId);
        return this.invokeHttpClient(internalRequest, GetSchedulerResultResponse.class);
    }

    public BaseResponse createOptimizationTask(OptimizationProblemRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "/v1/scheduler/problem/optimization");
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public GetSingleVehicleResultResponse getOptimizationTaskResult(String optimizationProblemId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v1/scheduler/problem/optimization/" + optimizationProblemId);
        return this.invokeHttpClient(internalRequest, GetSingleVehicleResultResponse.class);
    }

    public BaseResponse createOrderedTask(OrderedProblemRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "/v1/scheduler/problem/ordered");
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public GetSingleVehicleResultResponse getOrderedTaskResult(String orderedProblemId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v1/scheduler/problem/ordered/" + orderedProblemId);
        return this.invokeHttpClient(internalRequest, GetSingleVehicleResultResponse.class);
    }

    public MatrixResponse createMatrix(MatrixCreateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, MATRIX_PATH);
        return this.invokeHttpClient(internalRequest, MatrixResponse.class);
    }

    public MatrixResponse getMatrixStatus(String matrixId, String commitId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v1/matrix/" + matrixId + "/" + commitId);
        return this.invokeHttpClient(internalRequest, MatrixResponse.class);
    }

    public MatrixResponse updatePoint(MatrixPointRequest request, String matrixId) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "/v1/matrix/" + matrixId + "/point");
        return this.invokeHttpClient(internalRequest, MatrixResponse.class);
    }

    public MatrixResponse updateMatrix(MatrixUpdateRequest request, String matrixId) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "/v1/matrix/" + matrixId);
        return this.invokeHttpClient(internalRequest, MatrixResponse.class);
    }

    public MatrixResponse mixedUpdateMatrix(MatrixMixedUpdateRequest request, String matrixId) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "/v1/matrix/mixed");
        internalRequest.addParameter("matrixId", matrixId);
        return this.invokeHttpClient(internalRequest, MatrixResponse.class);
    }

    public void deleteMatrix(MatrixDeleteRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, MATRIX_PATH);
        internalRequest.addParameter("delete", "");
        this.invokeHttpClient(internalRequest, DeleteMatrixResponse.class);
    }

    public CurrentTaskResponse getTaskExecuteStatus() {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v1/matrix/current/task");
        return this.invokeHttpClient(internalRequest, CurrentTaskResponse.class);
    }

    public void updateTaskWeight(WeightUpdateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "/v1/matrix/weight");
        this.invokeHttpClient(internalRequest, UpdateWeightResponse.class);
    }

    public HighWayLocationResponse getMatrixHighWayLocation(String matrixId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v1/matrix/highway/" + matrixId);
        return this.invokeHttpClient(internalRequest, HighWayLocationResponse.class);
    }

    public BaseResponse createTask(String path, AbstractBceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, path);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }
}

