/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model;

import com.baidubce.BceClientException;
import com.baidubce.services.tablestorage.TableStorageConstants;
import com.baidubce.services.tablestorage.model.CellType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TableStorageCell {
    private static final int JSON_STR_LEN = "{\"column\":\"\",\"value\":\"\"}".length();
    private static final int NO_VALUE_JSON_STR_LEN = "{\"column\":\"\"}".length();
    private CellType cellType;
    private String column;
    private String value = "";
    private long timestamp;
    private int size;

    public TableStorageCell(CellType cellType, String column) {
        this.cellType = cellType;
        this.column = column;
        this.size = NO_VALUE_JSON_STR_LEN + column.length();
    }

    public TableStorageCell(CellType cellType, String column, String value) {
        this.cellType = cellType;
        this.column = column;
        this.value = value;
        this.size = JSON_STR_LEN + column.length() + value.length();
    }

    public TableStorageCell(CellType cellType, String column, String value, long timestamp) {
        this.cellType = cellType;
        this.column = column;
        this.value = value;
        this.timestamp = timestamp;
        this.size = JSON_STR_LEN + column.length() + value.length();
    }

    public String getColumn() {
        return this.column;
    }

    public String getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getSize() {
        return this.size;
    }

    protected static void checkCell(TableStorageCell cell) {
        if (cell == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)cell.column)) {
            throw new BceClientException("The column's value should not be blank.");
        }
        if (!Pattern.matches("[_a-zA-Z][_a-zA-Z0-9]{0,254}", cell.column)) {
            throw new BceClientException("The column's value should match the pattern : [_a-zA-Z][_a-zA-Z0-9]{0,254}. column=" + cell.column + ".");
        }
        if (cell.cellType == CellType.PutCell) {
            if (cell.value != null && cell.value.length() > 0x200000) {
                throw new BceClientException("The value's length should not exceed the limit 2097152. valueLength=" + cell.value.length() + ".");
            }
        } else if (!(cell.cellType != CellType.GetCell && cell.cellType != CellType.ScanCell && cell.cellType != CellType.DeleteCell || cell.value.isEmpty())) {
            throw new BceClientException("The value should be empty in GetCell, ScanCell and DeleteCell.");
        }
    }

    public String toString() {
        return "TableStorageCell [\n  column=" + this.column + ",\n  value=" + this.value + ",\n  timestamp=" + this.timestamp + "\n]";
    }

    public String toJsonString() {
        TableStorageCell.checkCell(this);
        StringBuffer buffer = new StringBuffer("{\"column\":\"");
        buffer.append(this.column);
        buffer.append("\"");
        if (this.cellType == CellType.PutCell) {
            try {
                buffer.append(",\"value\":\"");
                buffer.append(URLEncoder.encode(this.value, TableStorageConstants.DEFAULT_ENCODING));
                buffer.append("\"");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Value don't support " + TableStorageConstants.DEFAULT_ENCODING + " encode, column=" + this.column + ", value=" + this.value + ".");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }
}

