/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core.builder;

import com.baidubce.qianfan.Qianfan;
import com.baidubce.qianfan.core.builder.BaseBuilder;
import com.baidubce.qianfan.core.builder.MessageBuilder;
import com.baidubce.qianfan.model.chat.ChatRequest;
import com.baidubce.qianfan.model.chat.ChatResponse;
import com.baidubce.qianfan.model.chat.Function;
import com.baidubce.qianfan.model.chat.FunctionCall;
import com.baidubce.qianfan.model.chat.Message;
import com.baidubce.qianfan.model.chat.ToolChoice;
import java.util.Iterator;
import java.util.List;

public class ChatBuilder
extends BaseBuilder<ChatBuilder> {
    private final MessageBuilder messageBuilder = new MessageBuilder();
    private Double temperature;
    private Double topP;
    private Double penaltyScore;
    private String system;
    private List<String> stop;
    private Boolean disableSearch;
    private Boolean enableCitation;
    private Integer maxOutputTokens;
    private String responseFormat;
    private List<Function> functions;
    private ToolChoice toolChoice;

    public ChatBuilder() {
    }

    public ChatBuilder(Qianfan qianfan) {
        super(qianfan);
    }

    public ChatBuilder addMessage(Message message) {
        this.messageBuilder.add(message);
        return this;
    }

    public ChatBuilder addMessage(String role, String content) {
        this.messageBuilder.add(role, content);
        return this;
    }

    public ChatBuilder addUserMessage(String content) {
        this.messageBuilder.addUser(content);
        return this;
    }

    public ChatBuilder addAssistantMessage(String content) {
        this.messageBuilder.addAssistant(content);
        return this;
    }

    public ChatBuilder addFunctionCallMessage(FunctionCall functionCall) {
        this.messageBuilder.addFunctionCall(functionCall);
        return this;
    }

    public ChatBuilder addFunctionCallResultMessage(String name, String content) {
        this.messageBuilder.addFunctionCallResult(name, content);
        return this;
    }

    public ChatBuilder messages(MessageBuilder messages) {
        this.messageBuilder.messages(messages.build());
        return this;
    }

    public ChatBuilder messages(List<Message> messages) {
        this.messageBuilder.messages(messages);
        return this;
    }

    public ChatBuilder temperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public ChatBuilder topP(Double topP) {
        this.topP = topP;
        return this;
    }

    public ChatBuilder penaltyScore(Double penaltyScore) {
        this.penaltyScore = penaltyScore;
        return this;
    }

    public ChatBuilder system(String system) {
        this.system = system;
        return this;
    }

    public ChatBuilder stop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    public ChatBuilder disableSearch(Boolean disableSearch) {
        this.disableSearch = disableSearch;
        return this;
    }

    public ChatBuilder enableCitation(Boolean enableCitation) {
        this.enableCitation = enableCitation;
        return this;
    }

    public ChatBuilder maxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
        return this;
    }

    public ChatBuilder responseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public ChatBuilder functions(List<Function> functions) {
        this.functions = functions;
        return this;
    }

    public ChatBuilder toolChoice(ToolChoice toolChoice) {
        this.toolChoice = toolChoice;
        return this;
    }

    public ChatRequest build() {
        List<Message> messages = this.messageBuilder.build();
        return (ChatRequest)((ChatRequest)((ChatRequest)((ChatRequest)new ChatRequest().setMessages(messages).setTemperature(this.temperature).setTopP(this.topP).setPenaltyScore(this.penaltyScore).setSystem(this.system).setStop(this.stop).setDisableSearch(this.disableSearch).setEnableCitation(this.enableCitation).setMaxOutputTokens(this.maxOutputTokens).setResponseFormat(this.responseFormat).setFunctions(this.functions).setToolChoice(this.toolChoice).setModel(super.getModel())).setEndpoint(super.getEndpoint())).setUserId(super.getUserId())).setExtraParameters(super.getExtraParameters());
    }

    public ChatResponse execute() {
        return super.getQianfan().chatCompletion(this.build());
    }

    public Iterator<ChatResponse> executeStream() {
        return super.getQianfan().chatCompletionStream(this.build());
    }
}

