/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.util.http;

import com.baidubce.qianfan.util.Json;
import com.baidubce.qianfan.util.TypeRef;
import com.baidubce.qianfan.util.http.HttpRequest;
import com.baidubce.qianfan.util.http.HttpResponse;
import com.baidubce.qianfan.util.http.SSEWrapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class HttpClient {
    private static final int MAX_CONNECTIONS = 128;
    private static final CloseableHttpClient client;

    private HttpClient() {
    }

    public static HttpRequest request() {
        return new HttpRequest();
    }

    public static <T> HttpResponse<T> executeJson(ClassicHttpRequest request, TypeRef<T> typeRef) throws IOException {
        return HttpClient.executeJson(request, typeRef.getType());
    }

    public static <T> HttpResponse<T> executeJson(ClassicHttpRequest request, Type type) throws IOException {
        return HttpClient.execute(request, (body, resp) -> {
            String stringBody = EntityUtils.toString((HttpEntity)body);
            return resp.setStringBody(stringBody).setBody(Json.deserialize(stringBody, type));
        });
    }

    public static HttpResponse<String> executeString(ClassicHttpRequest request) throws IOException {
        return HttpClient.execute(request, (body, resp) -> {
            String stringBody = EntityUtils.toString((HttpEntity)body);
            return resp.setStringBody(stringBody).setBody(stringBody);
        });
    }

    public static HttpResponse<byte[]> execute(ClassicHttpRequest request) throws IOException {
        return HttpClient.execute(request, (body, resp) -> resp.setBody(EntityUtils.toByteArray((HttpEntity)body)));
    }

    private static <T> HttpResponse<T> execute(ClassicHttpRequest request, HttpResponseBodyHandler<T> bodyHandler) throws IOException {
        return (HttpResponse)client.execute(request, resp -> {
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            for (Header header : resp.getHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
            HttpResponse response = new HttpResponse().setCode(resp.getCode()).setHeaders(headers);
            return bodyHandler.handle(resp.getEntity(), response);
        });
    }

    public static HttpResponse<Iterator<String>> executeSSE(ClassicHttpRequest request) throws IOException {
        CloseableHttpResponse resp = client.execute(request);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (Header header : resp.getHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        Iterator<String> body = null;
        String stringBody = null;
        String contentType = headers.getOrDefault("Content-Type", "");
        if (contentType.startsWith("text/event-stream")) {
            body = SSEWrapper.wrap(resp.getEntity().getContent(), (AutoCloseable)resp);
        } else {
            try {
                stringBody = EntityUtils.toString((HttpEntity)resp.getEntity());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return new HttpResponse().setCode(resp.getCode()).setHeaders(headers).setBody(body).setStringBody(stringBody);
    }

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(128);
        cm.setDefaultMaxPerRoute(128);
        client = HttpClients.custom().useSystemProperties().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    @FunctionalInterface
    private static interface HttpResponseBodyHandler<T> {
        public HttpResponse<T> handle(HttpEntity var1, HttpResponse<T> var2) throws HttpException, IOException;
    }
}

