/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.util.http;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SSEWrapper {
    private SSEWrapper() {
    }

    public static Iterator<String> wrap(final InputStream stream, final AutoCloseable closeable) {
        return new Iterator<String>(){
            final BufferedReader reader;
            String nextLine;
            {
                this.reader = new BufferedReader(new InputStreamReader(stream));
                this.nextLine = null;
            }

            @Override
            public boolean hasNext() {
                if (this.nextLine != null) {
                    return true;
                }
                try {
                    this.nextLine = this.reader.readLine();
                    if (this.nextLine == null) {
                        this.silentlyClose();
                    }
                    return this.nextLine != null;
                }
                catch (Exception e) {
                    this.silentlyClose();
                    return false;
                }
            }

            @Override
            public String next() {
                if (this.nextLine != null || this.hasNext()) {
                    String lineToReturn = this.nextLine;
                    this.nextLine = null;
                    return lineToReturn;
                }
                this.silentlyClose();
                throw new NoSuchElementException();
            }

            private void silentlyClose() {
                try {
                    closeable.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }
}

