/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidGlobalDataSourceProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DynamicDataSourceCreator {
    private static final String DRUID_DATASOURCE = "com.alibaba.druid.pool.DruidDataSource";
    private Method createMethod;
    private Method typeMethod;
    private Method urlMethod;
    private Method usernameMethod;
    private Method passwordMethod;
    private Method driverClassNameMethod;
    private Method buildMethod;

    public DynamicDataSourceCreator() {
        Class<?> builderClass = null;
        try {
            builderClass = Class.forName("org.springframework.boot.jdbc.DataSourceBuilder");
        }
        catch (Exception e) {
            try {
                builderClass = Class.forName("org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.createMethod = builderClass.getDeclaredMethod("create", new Class[0]);
            this.typeMethod = builderClass.getDeclaredMethod("type", Class.class);
            this.urlMethod = builderClass.getDeclaredMethod("url", String.class);
            this.usernameMethod = builderClass.getDeclaredMethod("username", String.class);
            this.passwordMethod = builderClass.getDeclaredMethod("password", String.class);
            this.driverClassNameMethod = builderClass.getDeclaredMethod("driverClassName", String.class);
            this.buildMethod = builderClass.getDeclaredMethod("build", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DataSource createDataSource(DataSourceProperty dataSourceProperty, DruidGlobalDataSourceProperties druidDataSourceProperties) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        if (type == null) {
            try {
                Class.forName(DRUID_DATASOURCE);
                return this.createDruidDataSource(dataSourceProperty, druidDataSourceProperties);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else if (DRUID_DATASOURCE.equals(type.getName())) {
            return this.createDruidDataSource(dataSourceProperty, druidDataSourceProperties);
        }
        return this.createBasicDataSource(dataSourceProperty);
    }

    public DataSource createBasicDataSource(DataSourceProperty dataSourceProperty) {
        try {
            Object o1 = this.createMethod.invoke(null, new Object[0]);
            Object o2 = this.typeMethod.invoke(o1, dataSourceProperty.getType());
            Object o3 = this.urlMethod.invoke(o2, dataSourceProperty.getUrl());
            Object o4 = this.usernameMethod.invoke(o3, dataSourceProperty.getUsername());
            Object o5 = this.passwordMethod.invoke(o4, dataSourceProperty.getPassword());
            Object o6 = this.driverClassNameMethod.invoke(o5, dataSourceProperty.getDriverClassName());
            return (DataSource)this.buildMethod.invoke(o6, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public DataSource createDruidDataSource(DataSourceProperty dataSourceProperty, DruidGlobalDataSourceProperties druid) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(dataSourceProperty.getUrl());
        druidDataSource.setUsername(dataSourceProperty.getUsername());
        druidDataSource.setPassword(dataSourceProperty.getPassword());
        druidDataSource.setDriverClassName(dataSourceProperty.getDriverClassName());
        DruidDataSourceProperties properties = dataSourceProperty.getDruid();
        druidDataSource.setInitialSize(properties.getInitialSize() != null ? properties.getInitialSize().intValue() : druid.getInitialSize());
        druidDataSource.setMaxActive(properties.getMaxActive() != null ? properties.getMaxActive().intValue() : druid.getMaxActive());
        druidDataSource.setMinIdle(properties.getMinIdle() != null ? properties.getMinIdle().intValue() : druid.getMinIdle());
        druidDataSource.setMaxWait(properties.getMaxWait() != null ? properties.getMaxWait().longValue() : druid.getMaxWait());
        druidDataSource.setTimeBetweenEvictionRunsMillis(properties.getTimeBetweenEvictionRunsMillis() != null ? properties.getTimeBetweenEvictionRunsMillis().longValue() : druid.getTimeBetweenEvictionRunsMillis());
        druidDataSource.setMinEvictableIdleTimeMillis(properties.getMinEvictableIdleTimeMillis() != null ? properties.getMinEvictableIdleTimeMillis().longValue() : druid.getMinEvictableIdleTimeMillis());
        druidDataSource.setMaxEvictableIdleTimeMillis(properties.getMaxEvictableIdleTimeMillis() != null ? properties.getMaxEvictableIdleTimeMillis().longValue() : druid.getMaxEvictableIdleTimeMillis());
        druidDataSource.setValidationQuery(properties.getValidationQuery() != null ? properties.getValidationQuery() : druid.getValidationQuery());
        druidDataSource.setValidationQueryTimeout(properties.getValidationQueryTimeout() != null ? properties.getValidationQueryTimeout().intValue() : druid.getValidationQueryTimeout());
        druidDataSource.setTestOnBorrow(properties.getTestOnBorrow() != null ? properties.getTestOnBorrow().booleanValue() : druid.isTestOnBorrow());
        druidDataSource.setTestOnReturn(properties.getTestOnReturn() != null ? properties.getTestOnReturn().booleanValue() : druid.isTestOnReturn());
        druidDataSource.setTestWhileIdle(properties.getTestWhileIdle() != null ? properties.getTestWhileIdle().booleanValue() : druid.isTestWhileIdle());
        druidDataSource.setPoolPreparedStatements(properties.getPoolPreparedStatements() != null ? properties.getPoolPreparedStatements().booleanValue() : druid.isPoolPreparedStatements());
        druidDataSource.setMaxOpenPreparedStatements(properties.getMaxOpenPreparedStatements() != null ? properties.getMaxOpenPreparedStatements().intValue() : druid.getMaxOpenPreparedStatements());
        druidDataSource.setSharePreparedStatements(properties.getSharePreparedStatements() != null ? properties.getSharePreparedStatements().booleanValue() : druid.isSharePreparedStatements());
        druidDataSource.setConnectProperties(properties.getConnectionProperties() != null ? properties.getConnectionProperties() : druid.getConnectionProperties());
        try {
            druidDataSource.setFilters(properties.getFilters() != null ? properties.getFilters() : druid.getFilters());
            druidDataSource.init();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return druidDataSource;
    }
}

