/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.DynamicDataSourceClassResolver;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.spel.DynamicDataSourceSpelParser;
import com.baomidou.dynamic.datasource.spel.DynamicDataSourceSpelResolver;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.AnnotationUtils;

public class DynamicDataSourceAnnotationInterceptor
implements MethodInterceptor {
    private DynamicDataSourceSpelResolver dynamicDataSourceSpelResolver;
    private DynamicDataSourceSpelParser dynamicDataSourceSpelParser;
    private DynamicDataSourceClassResolver dynamicDataSourceClassResolver = new DynamicDataSourceClassResolver();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            DynamicDataSourceContextHolder.setDataSourceLookupKey(this.determineDatasource(invocation));
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceLookupKey();
        }
    }

    private String determineDatasource(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Class<?> declaringClass = this.dynamicDataSourceClassResolver.targetClass(invocation);
        DS ds = method.isAnnotationPresent(DS.class) ? method.getAnnotation(DS.class) : (DS)AnnotationUtils.findAnnotation(declaringClass, DS.class);
        String value = ds.value();
        if (!value.isEmpty() && value.startsWith("#")) {
            String spelValue = this.dynamicDataSourceSpelParser.parse(invocation, value);
            return this.dynamicDataSourceSpelResolver.resolve(spelValue);
        }
        return value;
    }

    public void setDynamicDataSourceSpelResolver(DynamicDataSourceSpelResolver dynamicDataSourceSpelResolver) {
        this.dynamicDataSourceSpelResolver = dynamicDataSourceSpelResolver;
    }

    public void setDynamicDataSourceSpelParser(DynamicDataSourceSpelParser dynamicDataSourceSpelParser) {
        this.dynamicDataSourceSpelParser = dynamicDataSourceSpelParser;
    }
}

