/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.DataCompute;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.exception.CellDependencyException;
import com.bstek.ureport.exception.DatasetUndefinitionException;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.ApplicationContext;

public class Context {
    private Report report;
    private Cell rootCell;
    private int pageIndex;
    private int totalPages;
    private boolean doPaging;
    private List<Row> currentPageRows;
    private Map<String, Dataset> datasetMap;
    private ApplicationContext applicationContext;
    private ReportBuilder reportBuilder;
    private Map<String, Object> parameters;
    private Map<String, List<Cell>> unprocessedCellsMap = new HashMap<String, List<Cell>>();
    private Map<Row, Map<Column, Cell>> blankCellsMap = new HashMap<Row, Map<Column, Cell>>();

    public Context(ReportBuilder reportBuilder, Report report, Map<String, Dataset> datasetMap, ApplicationContext applicationContext, Map<String, Object> parameters) {
        this.reportBuilder = reportBuilder;
        this.report = report;
        report.setContext(this);
        this.datasetMap = datasetMap;
        this.applicationContext = applicationContext;
        this.parameters = parameters;
        Map<String, List<Cell>> cellsMap = report.getCellsMap();
        for (String key : cellsMap.keySet()) {
            if (key.equals(report.getRootCell().getName())) continue;
            ArrayList list = new ArrayList();
            list.addAll(cellsMap.get(key));
            this.unprocessedCellsMap.put(key, list);
        }
        this.rootCell = new Cell();
        this.rootCell.setName("ROOT");
    }

    public ReportBuilder getReportBuilder() {
        return this.reportBuilder;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public boolean isDoPaging() {
        return this.doPaging;
    }

    public void setDoPaging(boolean doPaging) {
        this.doPaging = doPaging;
    }

    public List<BindData> buildCellData(Cell cell) {
        return DataCompute.buildCellData(cell, this);
    }

    public Cell getBlankCell(Row row, Column column) {
        Map<Column, Cell> colCellMap = this.blankCellsMap.get(row);
        if (colCellMap == null) {
            return null;
        }
        Cell targetCell = colCellMap.get(column);
        return targetCell;
    }

    public void removeBlankCell(Cell blankCell) {
        Row row = blankCell.getRow();
        Column col = blankCell.getColumn();
        Map<Column, Cell> colCellMap = this.blankCellsMap.get(row);
        colCellMap.remove(col);
    }

    public void addBlankCell(Cell cell) {
        cell.setBlankCell(true);
        Row row = cell.getRow();
        Column column = cell.getColumn();
        Map<Column, Cell> cellMap = this.blankCellsMap.get(row);
        if (cellMap == null) {
            cellMap = new HashMap<Column, Cell>();
            this.blankCellsMap.put(row, cellMap);
        }
        cellMap.put(column, cell);
        this.addReportCell(cell);
    }

    public void addCell(Cell newCell) {
        this.addReportCell(newCell);
        this.addUnprocessedCell(newCell);
    }

    public void addUnprocessedCell(Cell cell) {
        String cellName = cell.getName();
        List<Object> cells = null;
        if (this.unprocessedCellsMap.containsKey(cellName)) {
            cells = this.unprocessedCellsMap.get(cellName);
        } else {
            cells = new ArrayList();
            this.unprocessedCellsMap.put(cellName, cells);
        }
        cells.add(cell);
    }

    public Map<Row, Map<Column, Cell>> getBlankCellsMap() {
        return this.blankCellsMap;
    }

    public void addReportCell(Cell newCell) {
        boolean lazyAdd = this.report.addCell(newCell);
        if (lazyAdd) {
            return;
        }
        newCell.doFormat();
        newCell.doDataWrapCompute(this);
    }

    public Row getRow(int rowNumber) {
        return this.report.getRow(rowNumber);
    }

    public Column getColumn(int columnNumber) {
        return this.report.getColumn(columnNumber);
    }

    public Report getReport() {
        return this.report;
    }

    public List<?> getDatasetData(String name) {
        if (this.datasetMap.containsKey(name)) {
            return this.datasetMap.get(name).getData();
        }
        throw new DatasetUndefinitionException(name);
    }

    public List<Cell> nextUnprocessedCells() {
        if (this.unprocessedCellsMap.size() == 0) {
            return null;
        }
        List<Cell> targetCellsList = null;
        String targetCellName = null;
        Set<String> keySet = this.unprocessedCellsMap.keySet();
        for (String cellName : keySet) {
            List<Cell> cells = this.unprocessedCellsMap.get(cellName);
            Cell cell = cells.get(0);
            Cell leftParent = cell.getLeftParentCell();
            Cell topParent = cell.getTopParentCell();
            if (leftParent != null && !leftParent.isProcessed() || topParent != null && !topParent.isProcessed()) continue;
            targetCellsList = cells;
            targetCellName = cellName;
            break;
        }
        if (targetCellName == null) {
            throw new CellDependencyException();
        }
        this.unprocessedCellsMap.remove(targetCellName);
        return targetCellsList;
    }

    public boolean isCellPocessed(String cellName) {
        return !this.unprocessedCellsMap.containsKey(cellName);
    }

    public void addRow(Row row) {
        this.report.getRows().add(row);
    }

    public void addColumn(Column column) {
        this.report.getColumns().add(column);
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setCurrentPageRows(List<Row> currentPageRows) {
        this.currentPageRows = currentPageRows;
    }

    public List<Row> getCurrentPageRows() {
        return this.currentPageRows;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public Cell getRootCell() {
        return this.rootCell;
    }
}

