/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.build.cell.CellBuilder;
import com.bstek.ureport.build.cell.NoneExpandBuilder;
import com.bstek.ureport.build.cell.down.DownExpandBuilder;
import com.bstek.ureport.build.cell.right.RightExpandBuilder;
import com.bstek.ureport.build.paging.BasePagination;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.definition.Expand;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.datasource.BuildinDatasource;
import com.bstek.ureport.definition.datasource.BuildinDatasourceDefinition;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.datasource.DatasourceProvider;
import com.bstek.ureport.definition.datasource.JdbcDatasourceDefinition;
import com.bstek.ureport.definition.datasource.SpringBeanDatasourceDefinition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReportBuilder
extends BasePagination
implements ApplicationContextAware {
    public static final String BEAN_ID = "ureport.reportBuilder";
    private static final Logger log = Logger.getGlobal();
    private ApplicationContext applicationContext;
    private Map<String, DatasourceProvider> datasourceProviderMap = new HashMap<String, DatasourceProvider>();
    private Map<Expand, CellBuilder> cellBuildersMap = new HashMap<Expand, CellBuilder>();
    private NoneExpandBuilder noneExpandBuilder = new NoneExpandBuilder();

    public ReportBuilder() {
        this.cellBuildersMap.put(Expand.Right, new RightExpandBuilder());
        this.cellBuildersMap.put(Expand.Down, new DownExpandBuilder());
        this.cellBuildersMap.put(Expand.None, this.noneExpandBuilder);
    }

    public Report buildReport(ReportDefinition reportDefinition, Map<String, Object> parameters) {
        Report report = reportDefinition.newReport();
        Map<String, Dataset> datasetMap = this.buildDatasets(reportDefinition, parameters, this.applicationContext);
        Context context = new Context(this, report, datasetMap, this.applicationContext, parameters);
        long start = System.currentTimeMillis();
        List<Cell> cells = new ArrayList<Cell>();
        cells.add(report.getRootCell());
        do {
            this.buildCell(context, cells);
        } while ((cells = context.nextUnprocessedCells()) != null);
        this.recomputeCells(report, context);
        long end = System.currentTimeMillis();
        log.info("Report compute completed:" + (end - start) + "ms");
        return report;
    }

    public void buildCell(Context context, List<Cell> cells) {
        if (cells == null) {
            cells = context.nextUnprocessedCells();
        }
        if (cells == null) {
            return;
        }
        for (Cell cell : cells) {
            List<BindData> dataList = context.buildCellData(cell);
            cell.setProcessed(true);
            int size = dataList.size();
            if (size == 1) {
                this.noneExpandBuilder.buildCell(dataList, cell, context);
                continue;
            }
            if (size <= 1) continue;
            CellBuilder cellBuilder = this.cellBuildersMap.get((Object)cell.getExpand());
            cellBuilder.buildCell(dataList, cell, context);
        }
    }

    private Map<String, Dataset> buildDatasets(ReportDefinition reportDefinition, Map<String, Object> parameters, ApplicationContext applicationContext) {
        HashMap<String, Dataset> datasetMap = new HashMap<String, Dataset>();
        List<DatasourceDefinition> datasources = reportDefinition.getDatasources();
        if (datasources == null) {
            return datasetMap;
        }
        for (DatasourceDefinition dsDef : datasources) {
            DatasourceDefinition ds;
            List<Dataset> ls;
            Connection conn;
            String dsName;
            if (dsDef instanceof JdbcDatasourceDefinition) {
                dsName = dsDef.getName();
                conn = null;
                if (this.datasourceProviderMap.containsKey(dsName)) {
                    conn = this.datasourceProviderMap.get(dsName).getConnection();
                }
                if ((ls = ((JdbcDatasourceDefinition)(ds = (JdbcDatasourceDefinition)dsDef)).buildDatasets(conn, parameters)) == null) continue;
                for (Dataset dataset : ls) {
                    datasetMap.put(dataset.getName(), dataset);
                }
                continue;
            }
            if (dsDef instanceof SpringBeanDatasourceDefinition) {
                SpringBeanDatasourceDefinition ds2 = (SpringBeanDatasourceDefinition)dsDef;
                List<Dataset> ls2 = ds2.getDatasets(applicationContext, parameters);
                if (ls2 == null) continue;
                ls = ls2.iterator();
                while (ls.hasNext()) {
                    Dataset dataset = (Dataset)((Object)ls.next());
                    datasetMap.put(dataset.getName(), dataset);
                }
                continue;
            }
            if (!(dsDef instanceof BuildinDatasourceDefinition)) continue;
            dsName = dsDef.getName();
            conn = null;
            if (this.datasourceProviderMap.containsKey(dsName)) {
                conn = this.datasourceProviderMap.get(dsName).getConnection();
            }
            for (BuildinDatasource datasource : Utils.getBuildinDatasources()) {
                if (!datasource.name().equals(dsName)) continue;
                conn = datasource.getConnection();
                break;
            }
            if (conn == null) {
                throw new ReportComputeException("Buildin datasource [" + dsName + "] not exist.");
            }
            ds = (BuildinDatasourceDefinition)dsDef;
            ls = ((BuildinDatasourceDefinition)ds).buildDatasets(conn, parameters);
            if (ls == null) continue;
            for (Dataset dataset : ls) {
                datasetMap.put(dataset.getName(), dataset);
            }
        }
        return datasetMap;
    }

    private void recomputeCells(Report report, Context context) {
        List<Cell> lazyCells = report.getLazyComputeCells();
        for (Cell cell : lazyCells) {
            cell.doCompute(context);
        }
        context.setDoPaging(true);
        List<Row> rows = report.getRows();
        int rowSize = rows.size();
        Paper paper = report.getPaper();
        PagingMode pagingMode = paper.getPagingMode();
        List<Row> headerRows = report.getHeaderRepeatRows();
        List<Row> footerRows = report.getFooterRepeatRows();
        ArrayList<Page> pages = new ArrayList<Page>();
        ArrayList<Row> pageRows = new ArrayList<Row>();
        int pageIndex = 1;
        if (pagingMode.equals((Object)PagingMode.fitpage)) {
            int height = paper.getHeight() - paper.getBottomMargin() - paper.getTopMargin();
            if (paper.getOrientation().equals((Object)Orientation.landscape)) {
                height = paper.getWidth() - paper.getLeftMargin() - paper.getRightMargin();
            }
            int repeatRowHeight = 0;
            for (Row row : headerRows) {
                repeatRowHeight += row.getRealHeight();
            }
            for (Row row : footerRows) {
                repeatRowHeight += row.getRealHeight();
            }
            int rowHeight = repeatRowHeight;
            int i = 0;
            while (i < rowSize) {
                Row row = rows.get(i);
                int rowRealHeight = row.getRealHeight();
                if (rowRealHeight > 1 && row.getBand() == null) {
                    Row nextRow;
                    pageRows.add(row);
                    boolean overflow = false;
                    if (i + 1 < rows.size() && (rowHeight += rowRealHeight) + (nextRow = rows.get(i + 1)).getRealHeight() > height) {
                        overflow = true;
                    }
                    if (overflow) {
                        Page newPage = this.buildPage(pageRows, headerRows, footerRows, pageIndex, report);
                        ++pageIndex;
                        pages.add(newPage);
                        rowHeight = repeatRowHeight;
                        pageRows = new ArrayList();
                    }
                }
                this.processRowColumn(report, i, row);
                ++i;
            }
            if (rowHeight > 0) {
                Page newPage = this.buildPage(pageRows, headerRows, footerRows, pageIndex, report);
                pages.add(newPage);
            }
            this.buildPageHeaderFooter(pages, report);
        } else {
            int fixRows = paper.getFixRows();
            int i = 0;
            while (i < rowSize) {
                Row row = rows.get(i);
                this.processRowColumn(report, i, row);
                int height = row.getRealHeight();
                if (height >= 1) {
                    pageRows.add(row);
                    if (pageRows.size() + footerRows.size() >= fixRows) {
                        pageRows.addAll(footerRows);
                        Page newPage = this.buildPage(pageRows, headerRows, footerRows, pageIndex, report);
                        ++pageIndex;
                        pages.add(newPage);
                        pageRows = new ArrayList();
                    }
                }
                ++i;
            }
            if (pageRows.size() > headerRows.size()) {
                pageRows.addAll(footerRows);
                Page newPage = this.buildPage(pageRows, headerRows, footerRows, pageIndex, report);
                pages.add(newPage);
            }
            this.buildPageHeaderFooter(pages, report);
        }
        report.setPages(pages);
    }

    private void processRowColumn(Report report, int i, Row row) {
        Map<Row, Map<Column, Cell>> cellMap = report.getRowColCellMap();
        Map<Column, Cell> map = cellMap.get(row);
        if (map == null) {
            return;
        }
        List<Row> rows = report.getRows();
        List<Column> columns = report.getColumns();
        int colSize = columns.size();
        int j = 0;
        while (j < colSize) {
            Cell cell;
            Column col = columns.get(j);
            if (col != null && (cell = map.get(col)) != null) {
                int colWidth = col.getWidth();
                int colSpan = cell.getColSpan();
                if (colWidth < 1) {
                    if (colSpan > 1) {
                        if (--colSpan < 2) {
                            colSpan = 0;
                        }
                        cell.setColSpan(colSpan);
                        Column nextCol = columns.get(j + 1);
                        map.put(nextCol, cell);
                    }
                    map.remove(col);
                } else if (colSpan > 1) {
                    int start = j + 1;
                    int end = j + colSpan;
                    int num = start;
                    while (num < end) {
                        Column nextCol = columns.get(num);
                        if (nextCol.getWidth() < 1) {
                            --colSpan;
                        }
                        ++num;
                    }
                    if (colSpan < 2) {
                        colSpan = 0;
                    }
                    cell.setColSpan(colSpan);
                }
                int rowHeight = row.getRealHeight();
                int rowSpan = cell.getRowSpan();
                if (rowHeight < 1) {
                    if (rowSpan > 1) {
                        if (--rowSpan < 2) {
                            rowSpan = 0;
                        }
                        cell.setRowSpan(rowSpan);
                        Row nextRow = rows.get(i + 1);
                        Map<Column, Cell> cmap = cellMap.get(nextRow);
                        cmap.put(col, cell);
                    }
                } else if (rowSpan > 1) {
                    int start = i + 1;
                    int end = i + rowSpan;
                    int num = start;
                    while (num < end) {
                        Row nextRow = rows.get(num);
                        if (nextRow.getRealHeight() < 1) {
                            --rowSpan;
                        }
                        ++num;
                    }
                    if (rowSpan < 2) {
                        rowSpan = 0;
                    }
                    cell.setRowSpan(rowSpan);
                }
            }
            ++j;
        }
        if (row.getRealHeight() < 1) {
            cellMap.remove(row);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Collection datasourceProviders = applicationContext.getBeansOfType(DatasourceProvider.class).values();
        for (DatasourceProvider dp : datasourceProviders) {
            this.datasourceProviderMap.put(dp.getName(), dp);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("`7MMF'   `7MF'`7MM\"\"\"Mq.  `7MM\"\"\"YMM  `7MM\"\"\"Mq.   .g8\"\"8q.   `7MM\"\"\"Mq.  MMP\"\"MM\"\"YMM          ");
        sb.append("\n");
        sb.append("  MM       M    MM   `MM.   MM    `7    MM   `MM..dP'    `YM.   MM   `MM. P'   MM   `7          ");
        sb.append("\n");
        sb.append("  MM       M    MM   ,M9    MM   d      MM   ,M9 dM'      `MM   MM   ,M9       MM       pd*\"*b. ");
        sb.append("\n");
        sb.append("  MM       M    MMmmdM9     MMmmMM      MMmmdM9  MM        MM   MMmmdM9        MM      (O)   j8 ");
        sb.append("\n");
        sb.append("  MM       M    MM  YM.     MM   Y  ,   MM       MM.      ,MP   MM  YM.        MM          ,;j9 ");
        sb.append("\n");
        sb.append("  YM.     ,M    MM   `Mb.   MM     ,M   MM       `Mb.    ,dP'   MM   `Mb.      MM       ,-='    ");
        sb.append("\n");
        sb.append("   `bmmmmd\"'  .JMML. .JMM..JMMmmmmMMM .JMML.       `\"bmmd\"'   .JMML. .JMM.   .JMML.    Ammmmmmm ");
        sb.append("\n");
        sb.append(".....................................................................................................");
        sb.append("\n");
        sb.append(".  uReport, is a Chinese style report engine");
        sb.append(" licensed under the Apache License 2.0,                 .");
        sb.append("\n");
        sb.append(".  which is opensource, free of charge, easy to use,");
        sb.append("high-performance, with browser-based-designer.  .");
        sb.append("\n");
        sb.append(".....................................................................................................");
        sb.append("\n");
        System.out.println(sb.toString());
    }
}

