/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.aggregate;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.aggregate.Aggregate;
import com.bstek.ureport.definition.Order;
import com.bstek.ureport.definition.value.GroupItem;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.expr.dataset.DatasetExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomGroupAggregate
extends Aggregate {
    @Override
    public List<BindData> aggregate(DatasetExpression expr, Cell cell, Context context) {
        List<?> objList = this.fetchData(cell, context, expr.getDatasetName());
        List<BindData> list = this.doAggregate(expr, cell, context, objList);
        return list;
    }

    protected List<BindData> doAggregate(DatasetExpression expr, Cell cell, Context context, List<?> objList) {
        ArrayList<BindData> list = new ArrayList<BindData>();
        List<GroupItem> groupItems = expr.getGroupItems();
        if (objList.size() == 0) {
            list.add(new BindData(""));
            return list;
        }
        if (objList.size() == 1) {
            Object o = objList.get(0);
            boolean conditionResult = this.doCondition(expr.getCondition(), cell, o, context);
            if (!conditionResult) {
                list.add(new BindData(""));
                return list;
            }
            String itemName = this.groupData(groupItems, cell, context, o);
            if (itemName == null) {
                list.add(new BindData(""));
                return list;
            }
            ArrayList<Object> rowList = new ArrayList<Object>();
            rowList.add(o);
            list.add(new BindData(itemName, rowList));
            return list;
        }
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (Object o : objList) {
            String itemName;
            boolean conditionResult = this.doCondition(expr.getCondition(), cell, o, context);
            if (!conditionResult || (itemName = this.groupData(groupItems, cell, context, o)) == null) continue;
            List<Object> rowList = null;
            if (map.containsKey(itemName)) {
                rowList = (List)map.get(itemName);
            } else {
                rowList = new ArrayList();
                map.put(itemName, rowList);
                list.add(new BindData(itemName, rowList));
            }
            rowList.add(o);
        }
        if (list.size() == 0) {
            ArrayList<Object> rowList = new ArrayList<Object>();
            rowList.add(new HashMap());
            list.add(new BindData("", rowList));
        }
        if (list.size() > 1) {
            Order order = expr.getOrder();
            this.orderBindDataList(list, order);
        }
        return list;
    }

    private String groupData(List<GroupItem> groupItems, Cell cell, Context context, Object o) {
        for (GroupItem item : groupItems) {
            Condition condition = item.getCondition();
            boolean doCondition = this.doCondition(condition, cell, o, context);
            if (!doCondition) continue;
            return item.getName();
        }
        return null;
    }
}

