/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.aggregate;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.aggregate.Aggregate;
import com.bstek.ureport.definition.Order;
import com.bstek.ureport.expression.model.expr.dataset.DatasetExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectAggregate
extends Aggregate {
    @Override
    public List<BindData> aggregate(DatasetExpression expr, Cell cell, Context context) {
        List<?> objList = this.fetchData(cell, context, expr.getDatasetName());
        return this.doAggregate(expr, cell, context, objList);
    }

    protected List<BindData> doAggregate(DatasetExpression expr, Cell cell, Context context, List<?> objList) {
        ArrayList<BindData> list = new ArrayList<BindData>();
        Map<String, String> mappingMap = expr.getMapping();
        String property = expr.getProperty();
        for (Object o : objList) {
            boolean conditionResult = this.doCondition(expr.getCondition(), cell, o, context);
            if (!conditionResult) continue;
            ArrayList<Object> bindList = new ArrayList<Object>();
            bindList.add(o);
            Object data = Utils.getProperty(o, property);
            data = this.mappingData(mappingMap, data);
            list.add(new BindData(data, bindList));
        }
        if (list.size() == 0) {
            ArrayList<Object> rowList = new ArrayList<Object>();
            rowList.add(new HashMap());
            list.add(new BindData("", rowList));
        }
        if (list.size() > 1) {
            Order order = expr.getOrder();
            this.orderBindDataList(list, order);
        }
        return list;
    }
}

