/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.down;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.cell.down.CellDownDuplicator;
import com.bstek.ureport.build.cell.down.DownDuplocatorWrapper;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Row;
import java.util.List;

public class DownBlankCellApply {
    private int rowSize;
    private Cell cell;
    private Context context;
    private DownDuplocatorWrapper downDuplocatorWrapper;

    public DownBlankCellApply(int rowSize, Cell cell, Context context, DownDuplocatorWrapper downDuplocatorWrapper) {
        this.rowSize = rowSize;
        this.cell = cell;
        this.context = context;
        this.downDuplocatorWrapper = downDuplocatorWrapper;
    }

    public boolean useBlankCell(int index, BindData bindData) {
        if (this.context.getBlankCellsMap().size() == 0) {
            return false;
        }
        int nextRowNumber = this.cell.getRow().getRowNumber() + this.rowSize * (index - 1) + this.rowSize;
        Row nextRow = this.context.getRow(nextRowNumber);
        Cell blankCell = null;
        if (nextRow != null) {
            blankCell = this.context.getBlankCell(nextRow, this.cell.getColumn());
        }
        if (blankCell == null) {
            return false;
        }
        this.context.removeBlankCell(blankCell);
        blankCell.setValue(this.cell.getValue());
        blankCell.setProcessed(true);
        blankCell.setData(bindData.getValue());
        blankCell.setBindData(bindData.getDataList());
        this.processChildrenCell(this.cell, blankCell, index);
        return true;
    }

    private void processChildrenCell(Cell originalCell, Cell leftParentCell, int index) {
        List<CellDownDuplicator> children = this.downDuplocatorWrapper.fetchChildrenDuplicator(originalCell);
        if (children == null) {
            return;
        }
        for (CellDownDuplicator child : children) {
            Cell childCell = child.getCell();
            Cell targetCell = this.getChildBlankCell(childCell, index);
            if (targetCell == null) continue;
            this.context.removeBlankCell(targetCell);
            targetCell.setLeftParentCell(leftParentCell);
            targetCell.setValue(childCell.getValue());
            if (targetCell.getTopParentCell() == originalCell) {
                targetCell.setTopParentCell(leftParentCell);
            }
            this.context.addUnprocessedCell(targetCell);
            this.processChildrenCell(childCell, targetCell, index);
        }
    }

    private Cell getChildBlankCell(Cell childCell, int index) {
        int nextChildRowNumber = childCell.getRow().getRowNumber() + this.rowSize * (index - 1) + this.rowSize;
        Row nextChildRow = this.context.getRow(nextChildRowNumber);
        Column col = childCell.getColumn();
        Cell targetCell = this.context.getBlankCell(nextChildRow, col);
        return targetCell;
    }
}

