/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.right;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.cell.right.CellRightDuplicator;
import com.bstek.ureport.build.cell.right.RightDuplocatorWrapper;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Row;
import java.util.List;

public class RightBlankCellApply {
    private int colSize;
    private Cell cell;
    private Context context;
    private RightDuplocatorWrapper rightDuplocatorWrapper;

    public RightBlankCellApply(int colSize, Cell cell, Context context, RightDuplocatorWrapper rightDuplocatorWrapper) {
        this.colSize = colSize;
        this.cell = cell;
        this.context = context;
        this.rightDuplocatorWrapper = rightDuplocatorWrapper;
    }

    public boolean useBlankCell(int index, BindData bindData) {
        if (this.context.getBlankCellsMap().size() == 0) {
            return false;
        }
        int nextColNumber = this.cell.getColumn().getColumnNumber() + this.colSize * (index - 1) + this.colSize;
        Column nextCol = this.context.getColumn(nextColNumber);
        Cell blankCell = null;
        if (nextCol != null) {
            blankCell = this.context.getBlankCell(this.cell.getRow(), nextCol);
        }
        if (blankCell == null) {
            return false;
        }
        this.context.removeBlankCell(blankCell);
        blankCell.setValue(this.cell.getValue());
        blankCell.setProcessed(true);
        blankCell.setData(bindData.getValue());
        blankCell.setBindData(bindData.getDataList());
        this.processChildrenCell(this.cell, blankCell, index);
        return true;
    }

    private void processChildrenCell(Cell originalCell, Cell topParentCell, int index) {
        List<CellRightDuplicator> children = this.rightDuplocatorWrapper.fetchChildrenDuplicator(originalCell);
        if (children == null) {
            return;
        }
        for (CellRightDuplicator child : children) {
            Cell childCell = child.getCell();
            int nextChildColNumber = childCell.getColumn().getColumnNumber() + this.colSize * (index - 1) + this.colSize;
            Column nextChildCol = this.context.getColumn(nextChildColNumber);
            Row row = childCell.getRow();
            Cell targetCell = this.context.getBlankCell(row, nextChildCol);
            if (targetCell == null) continue;
            this.context.removeBlankCell(targetCell);
            targetCell.setTopParentCell(topParentCell);
            targetCell.setValue(childCell.getValue());
            if (originalCell == targetCell.getLeftParentCell()) {
                targetCell.setLeftParentCell(topParentCell);
            }
            this.context.addUnprocessedCell(targetCell);
            this.processChildrenCell(childCell, targetCell, index);
        }
    }
}

