/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.right;

import com.bstek.ureport.Range;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.cell.DuplicateType;
import com.bstek.ureport.build.cell.ExpandBuilder;
import com.bstek.ureport.build.cell.right.CellRightDuplicateUnit;
import com.bstek.ureport.build.cell.right.CellRightDuplicator;
import com.bstek.ureport.build.cell.right.RightBlankCellApply;
import com.bstek.ureport.build.cell.right.RightDuplocatorWrapper;
import com.bstek.ureport.definition.BlankCellInfo;
import com.bstek.ureport.definition.ConditionPropertyItem;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import java.util.List;
import java.util.Map;

public class RightExpandBuilder
extends ExpandBuilder {
    @Override
    public void buildCell(List<BindData> dataList, Cell cell, Context context) {
        Range duplicateRange = cell.getDuplicateRange();
        int mainCellColNumber = cell.getColumn().getColumnNumber();
        Range colRange = this.buildColRange(cell, duplicateRange, mainCellColNumber);
        RightDuplocatorWrapper rightDuplocatorWrapper = this.buildCellRightDuplicator(cell, context, colRange);
        int colSize = colRange.getEnd() - colRange.getStart() + 1;
        RightBlankCellApply rightBlankCellApply = new RightBlankCellApply(colSize, cell, context, rightDuplocatorWrapper);
        CellRightDuplicateUnit unit = new CellRightDuplicateUnit(context, rightDuplocatorWrapper, cell, mainCellColNumber, colSize);
        int i = 0;
        while (i < dataList.size()) {
            BindData bindData = dataList.get(i);
            if (i == 0) {
                cell.setData(bindData.getValue());
                cell.setBindData(bindData.getDataList());
                List<ConditionPropertyItem> conditionPropertyItems = cell.getConditionPropertyItems();
                if (conditionPropertyItems != null && conditionPropertyItems.size() > 0) {
                    context.getReport().getLazyComputeCells().add(cell);
                } else {
                    cell.doFormat();
                    cell.doDataWrapCompute(context);
                }
            } else {
                boolean useBlank = rightBlankCellApply.useBlankCell(i, bindData);
                if (!useBlank) {
                    Cell leftParentCell;
                    Cell newCell = cell.newCell();
                    newCell.setData(bindData.getValue());
                    newCell.setBindData(bindData.getDataList());
                    newCell.setProcessed(true);
                    Cell topParentCell = cell.getTopParentCell();
                    if (topParentCell != null) {
                        topParentCell.addColumnChild(newCell);
                    }
                    if ((leftParentCell = cell.getLeftParentCell()) != null) {
                        leftParentCell.addRowChild(newCell);
                    }
                    unit.duplicate(newCell, i);
                }
            }
            ++i;
        }
        unit.complete();
    }

    private Range buildColRange(Cell cell, Range range, int mainCellColNumber) {
        int start = mainCellColNumber + range.getStart();
        int end = mainCellColNumber + range.getEnd();
        return new Range(start, end);
    }

    private RightDuplocatorWrapper buildCellRightDuplicator(Cell cell, Context context, Range range) {
        RightDuplocatorWrapper duplicatorWrapper = new RightDuplocatorWrapper(cell.getName());
        this.buildParentCellDuplicators(cell, cell, duplicatorWrapper);
        int i = range.getStart();
        while (i <= range.getEnd()) {
            Column col = context.getColumn(i);
            List<Cell> colCells = col.getCells();
            for (Cell colCell : colCells) {
                this.buildDuplicator(duplicatorWrapper, cell, colCell, i);
            }
            ++i;
        }
        return duplicatorWrapper;
    }

    private void buildParentCellDuplicators(Cell cell, Cell mainCell, RightDuplocatorWrapper duplicatorWrapper) {
        Cell topParentCell = cell.getTopParentCell();
        if (topParentCell == null) {
            return;
        }
        this.buildDuplicator(duplicatorWrapper, mainCell, topParentCell, 0);
        this.buildParentCellDuplicators(topParentCell, mainCell, duplicatorWrapper);
    }

    private void buildDuplicator(RightDuplocatorWrapper duplicatorWrapper, Cell mainCell, Cell currentCell, int currentCellColNumber) {
        if (mainCell.equals(currentCell)) {
            return;
        }
        String name = currentCell.getName();
        Map<String, BlankCellInfo> newBlankCellNamesMap = mainCell.getNewBlankCellsMap();
        List<String> increaseCellNames = mainCell.getIncreaseSpanCellNames();
        List<String> newCellNames = mainCell.getNewCellNames();
        if (newBlankCellNamesMap.containsKey(name)) {
            if (!duplicatorWrapper.contains(currentCell)) {
                CellRightDuplicator cellDuplicator = new CellRightDuplicator(currentCell, DuplicateType.Blank, newBlankCellNamesMap.get(name), currentCellColNumber);
                duplicatorWrapper.addCellRightDuplicator(cellDuplicator);
            }
        } else if (increaseCellNames.contains(name)) {
            if (!duplicatorWrapper.contains(currentCell)) {
                CellRightDuplicator cellDuplicator = new CellRightDuplicator(currentCell, DuplicateType.IncreseSpan, currentCellColNumber);
                duplicatorWrapper.addCellRightDuplicator(cellDuplicator);
            }
        } else if (newCellNames.contains(name)) {
            CellRightDuplicator cellDuplicator = new CellRightDuplicator(currentCell, DuplicateType.Duplicate, currentCellColNumber);
            duplicatorWrapper.addCellRightDuplicator(cellDuplicator);
        } else if (mainCell.getName().equals(name)) {
            CellRightDuplicator cellDuplicator = new CellRightDuplicator(currentCell, DuplicateType.Self, currentCellColNumber);
            duplicatorWrapper.addCellRightDuplicator(cellDuplicator);
        }
    }
}

