/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.compute;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.compute.ValueCompute;
import com.bstek.ureport.definition.value.ExpressionValue;
import com.bstek.ureport.definition.value.ValueType;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.function.page.PageFunction;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.FunctionExpression;
import com.bstek.ureport.expression.model.expr.JoinExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseIfExpression;
import com.bstek.ureport.expression.model.expr.ifelse.IfExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class ExpressionValueCompute
implements ValueCompute {
    @Override
    public List<BindData> compute(Cell cell, Context context) {
        boolean hasPageFun;
        ExpressionValue exprValue = (ExpressionValue)cell.getValue();
        Expression expr = exprValue.getExpression();
        ArrayList<BindData> list = new ArrayList<BindData>();
        if (!context.isDoPaging() && (hasPageFun = this.hasPageFunction(expr))) {
            cell.setExistPageFunction(true);
            return list;
        }
        ExpressionData<?> data = expr.execute(cell, cell, context);
        if (data instanceof BindDataListExpressionData) {
            BindDataListExpressionData exprData = (BindDataListExpressionData)data;
            return exprData.getData();
        }
        Object obj = data.getData();
        if (obj instanceof List) {
            List listData = (List)obj;
            for (Object o : listData) {
                list.add(new BindData(o));
            }
        } else if (obj != null) {
            list.add(new BindData(obj));
        }
        return list;
    }

    private boolean hasPageFunction(Expression expr) {
        block12: {
            block13: {
                block11: {
                    if (expr == null) {
                        return false;
                    }
                    if (!(expr instanceof IfExpression)) break block11;
                    IfExpression ifExpr = (IfExpression)expr;
                    boolean has = this.hasPageFunction(ifExpr.getExpression());
                    if (has) {
                        return has;
                    }
                    ElseExpression elseExpr = ifExpr.getElseExpression();
                    if (elseExpr != null && (has = this.hasPageFunction(elseExpr.getExpression()))) {
                        return has;
                    }
                    List<ElseIfExpression> elseIfList = ifExpr.getElseIfExpressions();
                    if (elseIfList == null || elseIfList.size() == 0) {
                        return false;
                    }
                    for (ElseIfExpression elseIfExpr : elseIfList) {
                        has = this.hasPageFunction(elseIfExpr.getExpression());
                        if (!has) continue;
                        return has;
                    }
                    break block12;
                }
                if (!(expr instanceof JoinExpression)) break block13;
                JoinExpression joinExpr = (JoinExpression)expr;
                List<BaseExpression> list = joinExpr.getExpressions();
                if (list == null || list.size() == 0) {
                    return false;
                }
                for (BaseExpression baseExpr : list) {
                    boolean has = this.hasPageFunction(baseExpr);
                    if (!has) continue;
                    return has;
                }
                break block12;
            }
            if (!(expr instanceof FunctionExpression)) break block12;
            FunctionExpression funExpr = (FunctionExpression)expr;
            String name = funExpr.getName();
            Function fun = ExpressionUtils.getFunctions().get(name);
            if (fun == null) {
                throw new ReportComputeException("Function [" + name + "] not exist.");
            }
            if (fun instanceof PageFunction) {
                return true;
            }
            List<BaseExpression> list = funExpr.getExpressions();
            if (list == null || list.size() == 0) {
                return false;
            }
            for (BaseExpression baseExpr : list) {
                boolean has = this.hasPageFunction(baseExpr);
                if (!has) continue;
                return has;
            }
        }
        return false;
    }

    @Override
    public ValueType type() {
        return ValueType.expression;
    }
}

