/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.compute;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.compute.ValueCompute;
import com.bstek.ureport.definition.value.Source;
import com.bstek.ureport.definition.value.ValueType;
import com.bstek.ureport.definition.value.ZxingValue;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Image;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Base64Utils;

public class ZxingValueCompute
implements ValueCompute {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    @Override
    public List<BindData> compute(Cell cell, Context context) {
        ArrayList<BindData> list = new ArrayList<BindData>();
        ZxingValue value = (ZxingValue)cell.getValue();
        String format = value.getFormat();
        BarcodeFormat barcodeForamt = BarcodeFormat.QR_CODE;
        if (StringUtils.isNotBlank((CharSequence)format)) {
            barcodeForamt = BarcodeFormat.valueOf((String)format);
        }
        int w = value.getWidth();
        int h = value.getHeight();
        Source source = value.getSource();
        if (source.equals((Object)Source.text)) {
            String data = value.getValue();
            Image image = this.buildImage(barcodeForamt, data, w, h);
            list.add(new BindData(image));
        } else {
            Expression expression = value.getExpression();
            ExpressionData<?> data = expression.execute(cell, cell, context);
            Object obj = data.getData();
            if (obj instanceof List) {
                List listData = (List)obj;
                for (Object o : listData) {
                    if (o == null) continue;
                    Image image = this.buildImage(barcodeForamt, o.toString(), w, h);
                    list.add(new BindData(image));
                }
            } else if (obj instanceof String) {
                String text = obj.toString();
                if (text.startsWith("\"") && text.endsWith("\"")) {
                    text = text.substring(1, text.length() - 1);
                }
                Image image = this.buildImage(barcodeForamt, text, w, h);
                list.add(new BindData(image));
            } else if (obj != null) {
                Image image = this.buildImage(barcodeForamt, obj.toString(), w, h);
                list.add(new BindData(image));
            }
        }
        return list;
    }

    private Image buildImage(BarcodeFormat format, String data, int w, int h) {
        try {
            Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.MARGIN, 0);
            if (format.equals((Object)BarcodeFormat.QR_CODE)) {
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            }
            BitMatrix matrix = new MultiFormatWriter().encode(data, format, w, h, hints);
            int width = matrix.getWidth();
            int height = matrix.getHeight();
            BufferedImage image = new BufferedImage(width, height, 2);
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
                    ++y;
                }
                ++x;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", outputStream);
            byte[] bytes = outputStream.toByteArray();
            String base64Data = Base64Utils.encodeToString((byte[])bytes);
            IOUtils.closeQuietly((OutputStream)outputStream);
            return new Image(base64Data, w, h);
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
    }

    @Override
    public ValueType type() {
        return ValueType.zxing;
    }
}

