/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.paging;

import com.bstek.ureport.build.paging.BasePagination;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.build.paging.Pagination;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.util.ArrayList;
import java.util.List;

public class FitPagePagination
extends BasePagination
implements Pagination {
    @Override
    public List<Page> doPaging(Report report) {
        Paper paper = report.getPaper();
        int height = paper.getHeight() - paper.getBottomMargin() - paper.getTopMargin();
        if (paper.getOrientation().equals((Object)Orientation.landscape)) {
            height = paper.getWidth() - paper.getLeftMargin() - paper.getRightMargin();
        }
        List<Row> rows = report.getRows();
        List<Row> headerRows = report.getHeaderRepeatRows();
        List<Row> footerRows = report.getFooterRepeatRows();
        int repeatRowHeight = 0;
        for (Row row : headerRows) {
            repeatRowHeight += row.getRealHeight();
        }
        for (Row row : footerRows) {
            repeatRowHeight += row.getRealHeight();
        }
        int rowHeight = repeatRowHeight;
        ArrayList<Page> pages = new ArrayList<Page>();
        ArrayList<Row> pageRows = new ArrayList<Row>();
        int i = 0;
        int rowSize = rows.size();
        Row row = rows.get(i);
        int pageIndex = 1;
        while (row != null) {
            int rowRealHeight = row.getRealHeight();
            if (rowRealHeight > 1 && row.getBand() == null) {
                Row nextRow;
                pageRows.add(row);
                boolean overflow = false;
                if (i + 1 < rows.size() && (rowHeight += rowRealHeight) + (nextRow = rows.get(i + 1)).getRealHeight() > height) {
                    overflow = true;
                }
                if (overflow) {
                    Page newPage = this.buildPage(pageRows, headerRows, footerRows, pageIndex, report);
                    ++pageIndex;
                    pages.add(newPage);
                    rowHeight = repeatRowHeight;
                    pageRows = new ArrayList();
                }
            }
            row = ++i < rowSize ? rows.get(i) : null;
        }
        if (rowHeight > 0) {
            Page newPage = this.buildPage(pageRows, headerRows, footerRows, pageIndex, report);
            pages.add(newPage);
        }
        this.buildPageHeaderFooter(pages, report);
        return pages;
    }
}

