/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.paging;

import com.bstek.ureport.build.paging.BasePagination;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.build.paging.Pagination;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.util.ArrayList;
import java.util.List;

public class FixRowsPagination
extends BasePagination
implements Pagination {
    @Override
    public List<Page> doPaging(Report report) {
        Paper paper = report.getPaper();
        int fixRows = paper.getFixRows();
        List<Row> rows = report.getRows();
        List<Row> headerRows = report.getHeaderRepeatRows();
        List<Row> footerRows = report.getFooterRepeatRows();
        ArrayList<Page> pages = new ArrayList<Page>();
        ArrayList<Row> pageRows = new ArrayList<Row>();
        int pageIndex = 1;
        for (Row row : rows) {
            int height = row.getRealHeight();
            if (height < 1) continue;
            pageRows.add(row);
            if (pageRows.size() + footerRows.size() < fixRows) continue;
            pageRows.addAll(footerRows);
            Page newPage = this.buildPage(pageRows, headerRows, footerRows, pageIndex, report);
            ++pageIndex;
            pages.add(newPage);
            pageRows = new ArrayList();
        }
        if (pageRows.size() > headerRows.size()) {
            pageRows.addAll(footerRows);
            Page newPage = this.buildPage(pageRows, headerRows, footerRows, pageIndex, report);
            ++pageIndex;
            pages.add(newPage);
        }
        this.buildPageHeaderFooter(pages, report);
        return pages;
    }
}

