/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.paging.HeaderFooter;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import java.util.Iterator;
import org.codehaus.jackson.annotate.JsonIgnore;

public class HeaderFooterDefinition {
    private String left;
    private String center;
    private String right;
    private String fontFamily = "\u5b8b\u4f53";
    private int fontSize = 10;
    private String forecolor = "0,0,0";
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private int height = 30;
    private int margin = 30;
    @JsonIgnore
    private Expression leftExpression;
    @JsonIgnore
    private Expression centerExpression;
    @JsonIgnore
    private Expression rightExpression;

    public HeaderFooter buildHeaderFooter(int pageIndex, int totalPages, Context context) {
        Object obj;
        HeaderFooter hf = new HeaderFooter();
        hf.setBold(this.bold);
        hf.setFontFamily(this.fontFamily);
        hf.setFontSize(this.fontSize);
        hf.setForecolor(this.forecolor);
        hf.setHeight(this.height);
        hf.setItalic(this.italic);
        hf.setUnderline(this.underline);
        hf.setMargin(this.margin);
        context.setPageIndex(pageIndex);
        context.setTotalPages(totalPages);
        if (this.leftExpression != null && (obj = this.buildExpression(context, this.leftExpression)) != null) {
            hf.setLeft(obj.toString());
        }
        if (this.centerExpression != null && (obj = this.buildExpression(context, this.centerExpression)) != null) {
            hf.setCenter(obj.toString());
        }
        if (this.rightExpression != null && (obj = this.buildExpression(context, this.rightExpression)) != null) {
            hf.setRight(obj.toString());
        }
        return hf;
    }

    private Object buildExpression(Context context, Expression expr) {
        Object list;
        ObjectListExpressionData listData;
        ExpressionData<?> data = expr.execute(context.getRootCell(), context.getRootCell(), context);
        Object obj = null;
        if (data instanceof ObjectExpressionData) {
            obj = ((ObjectExpressionData)data).getData();
        } else if (data instanceof ObjectListExpressionData && (listData = (ObjectListExpressionData)data) != null && (list = listData.getData()) != null && list.size() > 0) {
            obj = "";
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o == null) continue;
                if (!obj.equals("")) {
                    obj = String.valueOf(obj) + ",";
                }
                obj = String.valueOf(obj) + o.toString();
            }
        }
        return obj;
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getCenter() {
        return this.center;
    }

    public void setCenter(String center) {
        this.center = center;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getForecolor() {
        return this.forecolor;
    }

    public void setForecolor(String forecolor) {
        this.forecolor = forecolor;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(Expression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public Expression getCenterExpression() {
        return this.centerExpression;
    }

    public void setCenterExpression(Expression centerExpression) {
        this.centerExpression = centerExpression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(Expression rightExpression) {
        this.rightExpression = rightExpression;
    }
}

