/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.dataset;

import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.dataset.Parameter;
import com.bstek.ureport.definition.datasource.DataType;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SqlDatasetDefinition
implements DatasetDefinition {
    private String name;
    private String sql;
    private List<Parameter> parameters;
    private List<Field> fields;

    public Dataset buildDataset(Map<String, Object> parameterMap, Connection conn) {
        Map<String, Object> pmap = this.buildParameters(parameterMap);
        SingleConnectionDataSource datasource = new SingleConnectionDataSource(conn, false);
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)datasource);
        List list = jdbcTemplate.queryForList(this.sql, pmap);
        return new Dataset(this.name, list);
    }

    private Map<String, Object> buildParameters(Map<String, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Parameter param : this.parameters) {
            String name = param.getName();
            DataType datatype = param.getType();
            Object value = param.getDefaultValue();
            if (params != null && params.containsKey(name)) {
                value = params.get(name);
            }
            map.put(name, datatype.parse(value));
        }
        return map;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }
}

