/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export;

import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.export.ExportConfigure;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.PageBuilder;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.export.SinglePageData;
import com.bstek.ureport.export.excel.ExcelProducer;
import com.bstek.ureport.export.html.HtmlProducer;
import com.bstek.ureport.export.html.HtmlReport;
import com.bstek.ureport.export.pdf.PdfProducer;
import com.bstek.ureport.export.word.WordProducer;
import com.bstek.ureport.model.Report;
import java.util.List;
import java.util.Map;

public class ExportManagerImpl
implements ExportManager {
    private ReportRender reportRender;
    private HtmlProducer htmlProducer = new HtmlProducer();
    private WordProducer wordProducer = new WordProducer();
    private ExcelProducer excelProducer = new ExcelProducer();
    private PdfProducer pdfProducer = new PdfProducer();

    @Override
    public HtmlReport exportHtml(String file, String contextPath, Map<String, Object> parameters) {
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        CacheUtils.storeReport(file, report);
        HtmlReport htmlReport = new HtmlReport();
        String content = this.htmlProducer.produce(report);
        htmlReport.setContent(content);
        htmlReport.setStyle(reportDefinition.getStyle());
        return htmlReport;
    }

    @Override
    public HtmlReport exportHtml(String file, String contextPath, Map<String, Object> parameters, int pageIndex) {
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = CacheUtils.getReport(file);
        if (report == null) {
            report = this.reportRender.render(reportDefinition, parameters);
            CacheUtils.storeReport(file, report);
        }
        SinglePageData pageData = PageBuilder.buildSinglePageData(pageIndex, report);
        List<Page> pages = pageData.getPages();
        String content = null;
        content = pages.size() == 1 ? this.htmlProducer.produce(report.getContext(), pages.get(0), false) : this.htmlProducer.produce(report.getContext(), pages, pageData.getColumnMargin(), false);
        HtmlReport htmlReport = new HtmlReport();
        htmlReport.setContent(content);
        htmlReport.setStyle(reportDefinition.getStyle());
        htmlReport.setPageIndex(pageIndex);
        htmlReport.setTotalPage(pageData.getTotalPages());
        return htmlReport;
    }

    @Override
    public void exportPdf(ExportConfigure config) {
        String file = config.getFile();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = CacheUtils.getReport(file);
        if (report == null) {
            report = this.reportRender.render(reportDefinition, config.getParameters());
            CacheUtils.storeReport(file, report);
        }
        this.pdfProducer.produce(report, config.getOutputStream());
    }

    @Override
    public void exportWord(ExportConfigure config) {
        String file = config.getFile();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = CacheUtils.getReport(file);
        if (report == null) {
            report = this.reportRender.render(reportDefinition, config.getParameters());
            CacheUtils.storeReport(file, report);
        }
        this.wordProducer.produce(report, config.getOutputStream());
    }

    @Override
    public void exportExcel(ExportConfigure config) {
        String file = config.getFile();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = CacheUtils.getReport(file);
        if (report == null) {
            report = this.reportRender.render(reportDefinition, config.getParameters());
            CacheUtils.storeReport(file, report);
        }
        this.excelProducer.produce(report, config.getOutputStream());
    }

    @Override
    public void exportExcelWithPaging(ExportConfigure config) {
        String file = config.getFile();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = CacheUtils.getReport(file);
        if (report == null) {
            report = this.reportRender.render(reportDefinition, config.getParameters());
            CacheUtils.storeReport(file, report);
        }
        this.excelProducer.produceWithPaging(report, config.getOutputStream());
    }

    @Override
    public void exportExcelWithPagingSheet(ExportConfigure config) {
        String file = config.getFile();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = CacheUtils.getReport(file);
        if (report == null) {
            report = this.reportRender.render(reportDefinition, config.getParameters());
            CacheUtils.storeReport(file, report);
        }
        this.excelProducer.produceWithSheet(report, config.getOutputStream());
    }

    public void setReportRender(ReportRender reportRender) {
        this.reportRender = reportRender;
    }
}

