/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export;

import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.Expand;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.exception.ReportParseException;
import com.bstek.ureport.export.builder.down.DownCellbuilder;
import com.bstek.ureport.export.builder.right.RightCellbuilder;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.parser.ReportParser;
import com.bstek.ureport.provider.report.ReportProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReportRender
implements ApplicationContextAware {
    private ReportParser reportParser;
    private ReportBuilder reportBuilder;
    private Collection<ReportProvider> reportProviders;
    private DownCellbuilder downCellParentbuilder = new DownCellbuilder();
    private RightCellbuilder rightCellParentbuilder = new RightCellbuilder();

    public Report render(String file, Map<String, Object> parameters) {
        ReportDefinition reportDefinition = this.getReportDefinition(file);
        return this.reportBuilder.buildReport(reportDefinition, parameters);
    }

    public Report render(ReportDefinition reportDefinition, Map<String, Object> parameters) {
        return this.reportBuilder.buildReport(reportDefinition, parameters);
    }

    public ReportDefinition getReportDefinition(String file) {
        ReportDefinition reportDefinition = CacheUtils.getReportDefinition(file);
        if (reportDefinition == null) {
            reportDefinition = this.parseReport(file);
            this.rebuildReportDefinition(reportDefinition);
            CacheUtils.cacheReportDefinition(file, reportDefinition);
        }
        return reportDefinition;
    }

    public void rebuildReportDefinition(ReportDefinition reportDefinition) {
        List<CellDefinition> cells = reportDefinition.getCells();
        for (CellDefinition cell : cells) {
            this.addRowChildCell(cell, cell);
            this.addColumnChildCell(cell, cell);
        }
        for (CellDefinition cell : cells) {
            Expand expand = cell.getExpand();
            if (expand.equals((Object)Expand.Down)) {
                this.downCellParentbuilder.buildParentCell(cell, cells);
                continue;
            }
            if (!expand.equals((Object)Expand.Right)) continue;
            this.rightCellParentbuilder.buildParentCell(cell, cells);
        }
    }

    public ReportDefinition parseReport(String file) {
        InputStream inputStream = null;
        try {
            ReportDefinition reportDefinition;
            inputStream = this.buildReportFile(file);
            ReportDefinition reportDefinition2 = reportDefinition = this.reportParser.parse(inputStream, file);
            return reportDefinition2;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new ReportParseException(e);
            }
        }
    }

    private InputStream buildReportFile(String file) {
        InputStream inputStream = null;
        for (ReportProvider provider : this.reportProviders) {
            if (!file.startsWith(provider.getPrefix())) continue;
            inputStream = provider.loadReport(file);
        }
        if (inputStream == null) {
            throw new ReportException("Report [" + file + "] not support.");
        }
        return inputStream;
    }

    private void addRowChildCell(CellDefinition cell, CellDefinition childCell) {
        CellDefinition leftCell = cell.getLeftParentCell();
        if (leftCell == null) {
            return;
        }
        List<CellDefinition> childrenCells = leftCell.getRowChildrenCells();
        childrenCells.add(childCell);
        this.addRowChildCell(leftCell, childCell);
    }

    private void addColumnChildCell(CellDefinition cell, CellDefinition childCell) {
        CellDefinition topCell = cell.getTopParentCell();
        if (topCell == null) {
            return;
        }
        List<CellDefinition> childrenCells = topCell.getColumnChildrenCells();
        childrenCells.add(childCell);
        this.addColumnChildCell(topCell, childCell);
    }

    public void setReportParser(ReportParser reportParser) {
        this.reportParser = reportParser;
    }

    public void setReportBuilder(ReportBuilder reportBuilder) {
        this.reportBuilder = reportBuilder;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.reportProviders = applicationContext.getBeansOfType(ReportProvider.class).values();
    }
}

